package com.jiejing.bff.crontab.server;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author chengyubing
 * @since 2024/3/7 11:14
 */
@Slf4j
@EnableAsync
@EnableScheduling
@EnableFeignClients(basePackages = {
    "com.jiejing.cam.api",
    "com.jiejing.member.api",
    "com.jiejing.paycenter.api",
    "com.jiejing.fitness.finance.api",
    "com.jiejing.studio.api"
})
@SpringBootApplication(scanBasePackages = "com.jiejing")
public class CrontabBffApplication {

  public static void main(String[] args) {

    SpringApplication.run(CrontabBffApplication.class, args);
    System.out.println("CrontabBffApplication start success!");
    log.info("CrontabBffApplication start success!");
  }

}
