package com.jiejing.bff.crontab.server.cam;

import com.jiejing.cam.api.schedule.ScheduleQueueApi;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 约课排队任务
 *
 * @author chengyubing
 * @since 2024/3/7 10:56
 */
@Component
public class ScheduleQueueJob {

  @Resource
  private ScheduleQueueApi scheduleQueueApi;

  /**
   * 每1分钟执行一次
   */
  @Scheduled(cron = "0 0/1 * * * ?")
  public void autoRemove() {
    scheduleQueueApi.autoCancel();
  }

}
