package com.jiejing.bff.crontab.server.cam;

import com.google.common.collect.Lists;
import com.jiejing.cam.api.message.ClassStartReminderDayTaskApi;
import com.jiejing.cam.common.request.schedule.ClassStartReminderRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author xiezhongtao
 * @date 2024/5/15 16:26
 */


@Component
@Slf4j
public class ClassStartReminderJob {

  @Autowired
  private ClassStartReminderDayTaskApi classStartReminderDayTaskApi;


  @Scheduled(cron = "* 15 10 * * ?")
  public void createClassStartTask() {
    log.info("生成上课提醒任务 开始 ===>");
    ClassStartReminderRequest request = ClassStartReminderRequest.builder()
        .studioId(null).build();
    classStartReminderDayTaskApi.createClassStartReminderDayTask(request);
    log.info("生成上课提醒任务 结束===>");
  }
  @Scheduled(cron = "* * 20 * * ?")
  public void sendClassStartMessage() {
    log.info("发送上课提醒消息 开始 ===>");
    ClassStartReminderRequest request = ClassStartReminderRequest.builder()
        .targets(Lists.newArrayList("ADMIN", "MEMBER")).build();
    classStartReminderDayTaskApi.sendClassStartReminder(request);
    log.info("发送上课提醒消息 结束 ===>");
  }
}
