package com.jiejing.bff.crontab.server.cam;

import com.jiejing.cam.api.schedule.ScheduleCancelPlanApi;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 课次自动取消计划任务
 *
 * @author chengyubing
 * @since 2024/3/7 10:56
 */
@Component
public class ScheduleAutoCancelJob {

  @Resource
  private ScheduleCancelPlanApi scheduleCancelPlanApi;

  /**
   * 每10分钟执行一次
   */
  @Scheduled(cron = "0 0/10 * * * ?")
  public void autoRemove() {
    scheduleCancelPlanApi.autoRemovePlan();
  }

  /**
   * 每分钟执行一次
   */
  @Scheduled(cron = "0 0/1 * * * ?")
  public void autoCancel() {
    scheduleCancelPlanApi.autoCancelSchedule();
  }

}
