package com.jiejing.bff.crontab.server.finance;

import com.jiejing.fitness.finance.api.task.FitFinanceTaskApi;
import com.jiejing.fitness.finance.api.task.request.CheckSettleRequest;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/4/7 14:20
 */
@Component
public class FitFinanceJob {

  @Resource
  private FitFinanceTaskApi fitFinanceTaskApi;

  /**
   * 对账
   */
  @Scheduled(cron = "0 0 3 * * ?")
  public void checkSettle() {
    fitFinanceTaskApi.checkSettle(CheckSettleRequest.builder().build());
  }

  /**
   * 同步结算状态
   */
  @Scheduled(cron = "0 0 19 * * ?")
  public void syncSettle() {
    fitFinanceTaskApi.syncSettle(CheckSettleRequest.builder().build());
  }

}
