package com.jiejing.bff.crontab.server.paycenter;

import com.jiejing.paycenter.api.task.PayCenterTaskApi;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/4/7 11:03
 */
@Component
public class PayCenterJob {

  @Resource
  private PayCenterTaskApi payCenterTaskApi;

  @Scheduled(cron = "0 0/5 * * * ?")
  public void autoApplyMerchant() {
    payCenterTaskApi.autoApplyMerchant();
  }

  @Scheduled(cron = "0 0/1 * * * ?")
  public void closePay() {
    payCenterTaskApi.closePay();
  }

  @Scheduled(cron = "0 0/1 * * * ?")
  public void syncPay() {
    payCenterTaskApi.syncPay();
  }

}
