package com.jiejing.bff.crontab.server.notify;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jiejing.cronjob.handler.ICronJobHandler;
import com.jiejing.cronjob.model.CronJobContext;
import com.jiejing.fitness.enums.message.ReceiveTypeEnum;
import com.jiejing.notify.api.ClassStartReminderDayTaskApi;
import com.jiejing.notify.common.request.task.ClassStartReminderRequest;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author xiezhongtao
 * @date 2024/6/4 10:25
 */
@Component
@Slf4j
public class CreateScheduleNotifyTaskCronHandler implements ICronJobHandler {

  @Resource
  private ClassStartReminderDayTaskApi classStartReminderDayTaskApi;

  @Override
  public String jobCode() {
    return "create_schedule_notify_task";
  }

  @Override
  public Object execute(CronJobContext context, String jobParams) {
    log.info("创建课次通知任务  context:{}   jobParams:{}", context, jobParams);
    Integer retryIndex = context.getRetryIndex();
    if (null == retryIndex) {
      retryIndex = 0;
    }
    if (retryIndex > 3) {
      throw new RuntimeException("error on retry #" + retryIndex);
    }
    ClassStartReminderRequest request = ClassStartReminderRequest.builder()
        .targets(Lists.newArrayList(ReceiveTypeEnum.ADMIN.name(), ReceiveTypeEnum.MEMBER.name()))
        .build();
    classStartReminderDayTaskApi.createClassStartReminderDayTask(request);
    return new JSONObject().fluentPut("result", "Succeeded on retry #" + retryIndex);
  }
}
