package com.jiejing.fitness.finance.api.merchant.request;

import com.jiejing.paycenter.common.enums.common.PayChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/27 10:54
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "获取openIdRequest")
public class GetOpenIdRequest {

  @ApiModelProperty(value = "支付渠道", required = true)
  @NotNull(message = "支付渠道不能为空")
  private PayChannelEnums channel;

  @ApiModelProperty(name = "应用ID", required = true)
  @NotBlank(message = "应用ID不能为空")
  private String appId;

  @ApiModelProperty(name = "authCode", required = true)
  @NotBlank(message = "authCode不能为空")
  private String authCode;

}
