package com.jiejing.fitness.finance.api.merchant.vo;

import com.jiejing.common.swagger.EnumMapping;
import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import com.jiejing.paycenter.common.enums.error.PayErrorEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/5/10 13:40
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆商户退款VO")
public class StudioMerchantRefundVO {

  @ApiModelProperty(name = "退款单号")
  private String transNo;

  @EnumMapping(enumClass = TransStateEnums.class)
  @ApiModelProperty(name = "退款状态")
  private String refundState;

  @ApiModelProperty(name = "三方交易单号")
  private String thirdTransNo;

  @ApiModelProperty(name = "失败原因")
  private String failMessage;

  @ApiModelProperty(name = "完成时间")
  private Date successTime;

  @EnumMapping(enumClass = CheckRefundCodeEnum.class)
  @ApiModelProperty(value = "具体的错误码", notes = "退款校验或者退款失败时此code有值")
  private String code;

  @Getter
  @AllArgsConstructor
  public enum CheckRefundCodeEnum {

    /**
     * 退款校验CODE，退款失败CODE
     */
    SUCCESS("校验成功"),
    NOT_CURRENT_MERCHANT("不是当前商户号收款，金额无法线上原路退回。如仍需退款请私下处理，系统会产生新的收支"),
    DATE_LIMIT("仅支持350天内交易进行退款，金额无法线上原路退回。如仍需退款请私下处理，系统会产生新的收支"),
    TIME_LIMIT("当前时间段不支持退款，金额无法线上原路退回。如仍需退款请私下处理，系统会产生新的收支"),
    AMOUNT_LIMIT("乐动收银可退金额不足"),
    OTHER_ERROR("其他错误"),
    ;

    private final String code = name();
    private final String message;

    public static CheckRefundCodeEnum getByCode(String code) {
      return Arrays.stream(CheckRefundCodeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst()
          .orElse(OTHER_ERROR);
    }

    public static boolean isSuccess(String code) {
      return CheckRefundCodeEnum.SUCCESS == getByCode(code);
    }

    public static boolean isFail(String code) {
      return !isSuccess(code);
    }
  }

}
