package com.jiejing.fitness.finance.service.pay.enums;

import static com.jiejing.fitness.finance.service.enums.FinanceErrorEnums.*;
import static com.jiejing.fitness.finance.service.enums.FinanceErrorEnums.PAY_FAIL_1;
import static com.jiejing.fitness.finance.service.enums.FinanceErrorEnums.PAY_FAIL_4;
import static com.jiejing.fitness.finance.service.enums.FinanceErrorEnums.PAY_FAIL_5;

import com.jiejing.fitness.finance.service.enums.FinanceErrorEnums;
import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/4/19 12:17
 */
@Getter
@AllArgsConstructor
public enum PayFailMessageReplaceEnums {

  /**
   *
   */
  OTHER("OTHER", PAY_FAIL_1),
  E1("交易失败，结算账户状态异常", PAY_FAIL_2),
  E2("参数buyerId和buyerLongId不能同时为空", PAY_FAIL_3),
  E3("参数openId不能为空", PAY_FAIL_3),
  E4("特约子商户该产品权限已被冻结，请前往商户平台>产品中心检查后重试", PAY_FAIL_1),
  E5("当前商户需补齐相关资料后，才可进行相应的支付交易，请商户联系对接的微信支付服务商", PAY_FAIL_4),
  E6("当前商户需补齐相关资料后，才可进行相应的支付交易，请商户联系对接的支付宝服务商", PAY_FAIL_5),
  E7("商户不存在", PAY_FAIL_1),
  E8("风控拦截[单笔限额拦截]", PAY_FAIL_6),
  E9("风控拦截[单日限额拦截]", PAY_FAIL_7),
  E10("交易失败，请重试cashCode:38 cashDesc: 该商户无此通道入驻记录或商户不可用！", PAY_FAIL_1),
  ;

  private final String source;

  private final FinanceErrorEnums target;

  public static FinanceErrorEnums convertBySource(String source) {
    if (null == source) {
      return OTHER.getTarget();
    }
    return Arrays.stream(PayFailMessageReplaceEnums.values())
        .filter(e -> e.getSource().contains(source) || source.contains(e.getSource())).findFirst()
        .orElse(OTHER).getTarget();
  }


}
