package com.jiejing.fitness.finance.service.pay.enums;

import java.util.Arrays;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/4/19 12:17
 */
@Getter
@AllArgsConstructor
public enum PayFailMessageReplaceEnums {

  /**
   *
   */
  E1("交易失败，结算账户状态异常", "收款账户状态异常，请联系场馆工作人员处理。"),
  E2("参数buyerId和buyerLongId不能同时为空", "网络异常支付失败，请重新支付。"),
  E3("参数openId不能为空", "网络异常支付失败，请重新支付。"),
  E4("特约子商户该产品权限已被冻结，请前往商户平台>产品中心检查后重试", "支付失败，请联系场馆工作人员处理。"),
  E5("当前商户需补齐相关资料后，才可进行相应的支付交易，请商户联系对接的微信支付服务商",
      "支付失败，请联系场馆工作人员进行微信授权。"),
  E6("当前商户需补齐相关资料后，才可进行相应的支付交易，请商户联系对接的支付宝服务商",
      "支付失败，请联系场馆工作人员进行支付宝授权。"),
  E7("商户不存在", "支付失败，请联系场馆工作人员处理。"),
  E8("风控拦截[单笔限额拦截]", "该场馆单笔收款有额度限制，请联系场馆提升收款额度或者分多笔订单支付。"),
  E9("风控拦截[单日限额拦截]", "该场馆单日收款有额度限制，请联系场馆提升收款额度。"),
  E10("交易失败，请重试cashCode:38 cashDesc: 该商户无此通道入驻记录或商户不可用！",
      "支付失败，请联系场馆工作人员处理。"),
  OTHER("OTHER", "支付失败，请联系场馆工作人员处理。"),
  ;

  private final String source;

  private final String target;

  public static String convertBySource(String source) {
    if (null == source) {
      return OTHER.getTarget();
    }
    return Arrays.stream(PayFailMessageReplaceEnums.values())
        .filter(e -> e.getSource().contains(source) || source.contains(e.getSource())).findFirst()
        .orElse(OTHER).getTarget();
  }


}
