package com.jiejing.fitness.finance.app.controller.task;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.task.FitFinanceTaskApi;
import com.jiejing.fitness.finance.api.task.request.CheckSettleRequest;
import com.jiejing.fitness.finance.service.pay.PayService;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author chengyubing
 * @since 2024/4/7 13:52
 */
@Component
public class FitFinanceTaskController implements FitFinanceTaskApi {

  @Resource
  private PayService payService;


  @ApiOperation(value = "对账", tags = {TAG})
  @PostMapping(value = "/private/task/checkSettle")
  @Override
  public JsonResult<Void> checkSettle(@Valid @RequestBody CheckSettleRequest request) {
    payService.checkSettle(request.getMerchantId(), request.getSettleDate());
    return JsonResult.success();
  }
}
