package com.jiejing.fitness.finance.api.merchant.request;

import com.jiejing.paycenter.common.enums.merchant.SubChannelAuthTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/2/26 13:58
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "品牌商户授权子渠道")
public class AuthBrandMerchantSubChannelRequest {

  @ApiModelProperty(value = "品牌ID", required = true)
  @NotNull(message = "品牌ID不能为空")
  private Long brandId;

  @ApiModelProperty(value = "子渠道", required = true)
  @NotNull(message = "子渠道不能为空")
  private SubChannelEnums subChannel;

  @ApiModelProperty(value = "子渠道认证类型", required = true)
  @NotNull(message = "子渠道认证类型不能为空")
  private SubChannelAuthTypeEnums authType;

}
