/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.common.utils.text.StringUtil;
import com.jiejing.fitness.finance.repository.entity.BrandCashierRecord;
import com.jiejing.fitness.finance.repository.mapper.BrandCashierRecordMapper;
import com.jiejing.fitness.finance.repository.query.PageBrandCashierRecordQuery;
import com.jiejing.mbp.MapperRepoService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 品牌收银流水 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-02-27
 */
@Service
public class BrandCashierRecordRpService extends
    MapperRepoService<Long, BrandCashierRecord, BrandCashierRecordMapper> {

  public BigDecimal sumRefundActualAmountByPayTransNo(String payTransNo) {
    return this.baseMapper.sumRefundActualAmountByPayTransNo(payTransNo);
  }

  public List<BrandCashierRecord> listByOrderNo(String orderNo) {
    QueryWrapper<BrandCashierRecord> wrapper = new QueryWrapper<>();
    wrapper.eq(BrandCashierRecord.ORDER_NO, orderNo);
    return this.baseMapper.selectList(wrapper);
  }

  public Page<BrandCashierRecord> page(PageBrandCashierRecordQuery query) {
    QueryWrapper<BrandCashierRecord> wrapper = new QueryWrapper<>();
    if (StringUtil.isNotBlank(query.getOrderNo())) {
      wrapper.eq(BrandCashierRecord.ORDER_NO, query.getOrderNo());
    }
    if (StringUtil.isNotBlank(query.getTransNo())) {
      wrapper.eq(BrandCashierRecord.TRANS_NO, query.getTransNo());
    }
    if (StringUtil.isNotBlank(query.getThirdTransNo())) {
      wrapper.eq(BrandCashierRecord.THIRD_TRANS_NO, query.getThirdTransNo());
    }
    if (null != query.getStudioId()) {
      wrapper.eq(BrandCashierRecord.STUDIO_ID, query.getStudioId());
    }
    if (StringUtil.isNotBlank(query.getBuyerName())) {
      wrapper.eq(BrandCashierRecord.BUYER_NAME, query.getBuyerName());
    }
    if (null != query.getTransState()) {
      wrapper.eq(BrandCashierRecord.TRANS_STATE, query.getTransState());
    }
    if (null != query.getOrderType()) {
      wrapper.eq(BrandCashierRecord.ORDER_TYPE, query.getOrderType());
    }
    if (null != query.getTransType()) {
      wrapper.eq(BrandCashierRecord.TRANS_TYPE, query.getTransType());
    }
    if (null != query.getSubChannel()) {
      wrapper.eq(BrandCashierRecord.SUB_CHANNEL, query.getSubChannel());
    }
    if (null != query.getCreateStartTime()) {
      wrapper.ge(BrandCashierRecord.CREATE_TIME, query.getCreateStartTime());
    }
    if (null != query.getCreateEndTime()) {
      wrapper.le(BrandCashierRecord.CREATE_TIME, query.getCreateEndTime());
    }
    if (null != query.getSuccessStartTime()) {
      wrapper.ge(BrandCashierRecord.SUCCESS_TIME, query.getSuccessStartTime());
    }
    if (null != query.getSuccessEndTime()) {
      wrapper.le(BrandCashierRecord.SUCCESS_TIME, query.getSuccessEndTime());
    }
    return this.findByWrapperPage(wrapper, query.getCurrent(), query.getSize());
  }
}
