/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆半屏小程序申请记录
 * </p>
 *
 * @author chengyubing, created on 2024-08-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioEmbeddedXcxApply implements Serializable {

  private static final long serialVersionUID = -4415580599984265484L;

  /**
   * 备注: 主键 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 场馆ID 是否允许为null: YES
   */
  private Long studioId;

  /**
   * 备注: 第三方平台appId 是否允许为null: YES
   */
  private String componentAppId;

  /**
   * 备注: 授权方appId（专属小程序） 是否允许为null: YES
   */
  private String authorizerAppId;

  /**
   * 备注: 支付小程序appId 是否允许为null: YES
   */
  private String appId;

  /**
   * 备注: 状态 是否允许为null: YES
   */
  private String state;

  /**
   * 备注: 失败原因 是否允许为null: YES
   */
  private String message;

  /**
   * 备注: 创建时间 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String STUDIO_ID = "studio_id";

  public static final String COMPONENT_APP_ID = "component_app_id";

  public static final String AUTHORIZER_APP_ID = "authorizer_app_id";

  public static final String APP_ID = "app_id";

  public static final String STATE = "state";

  public static final String MESSAGE = "message";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
