package com.jiejing.fitness.finance.app.controller;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.common.model.JsonResult;
import com.jiejing.filecenter.api.authority.AuthorityApi;
import com.jiejing.filecenter.api.authority.request.GetAuthorityRequest;
import com.jiejing.filecenter.api.authority.vo.SignatureVO;
import com.jiejing.filecenter.api.common.enums.AccessTypeEnum;
import com.jiejing.filecenter.api.common.util.UploadUtil;
import com.jiejing.filecenter.api.resource.ResourceApi;
import com.jiejing.fitness.finance.repository.service.StudioCashierRecordRpService;
import com.jiejing.fitness.finance.service.merchant.StudioMerchantService;
import com.jiejing.fitness.finance.service.utils.FileUtils;
import com.jiejing.paycenter.api.merchant.MerchantQueryApi;
import com.jiejing.paycenter.common.event.MerchantEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/26 10:01
 */
@RestController
public class TestController {

  @Resource
  private MerchantQueryApi merchantApi;

  @Resource
  private ResourceApi resourceApi;

  @Resource
  private AuthorityApi authorityApi;

  @PostMapping(value = "/private/test/upload")
  public JsonResult<SignatureVO> upload(@RequestParam String url, @RequestParam Long tenantId)
      throws IOException {
    GetAuthorityRequest request = new GetAuthorityRequest();
    request.setAccessTypeEnum(AccessTypeEnum.PRIVATE);
    request.setBizCode("FINANCE_INFO");
    request.setTenantId(tenantId);
    request.setTenantType("BRAND");
    request.setResourceName(IdWorker.getIdStr() + getSuffix(url));
    Map<String, String> params = new HashMap<>(1);
    params.put("tenantId", tenantId.toString());
    request.setParamMap(params);
    JsonResult<SignatureVO> result = authorityApi.getAuthoritySignatureForInner(request);
    result.assertSuccess();
    SignatureVO signatureVO = result.getResult();
    UploadUtil.uploadFile(FileUtils.getInputStream(url), request.getResourceName(), signatureVO, 1000000);
    return result;
  }

  @Resource
  private StudioCashierRecordRpService studioCashierRecordRpService;

  @Resource
  private StudioMerchantService studioMerchantService;


  @PostMapping(value = "/private/test/merchantCallback")
  public JsonResult<Map<Long, BigDecimal>> merchantCallback(@RequestBody MerchantEvent event) {
    studioMerchantService.callback(event);
    return JsonResult.success();
  }


  private String getSuffix(String url) {
    String[] split = url.split("\\?");
    String fileName = StringUtils.substringAfterLast(split[0], "/");
    String[] names = fileName.split("\\.");
    return "." + names[names.length - 1];
  }

}
