package com.jiejing.fitness.finance.service.enums;

import com.jiejing.common.exception.BaseBizError;
import lombok.Getter;

/**
 * @author chengyubing
 * @since 2024/2/21 14:54
 */
@Getter
public enum FinanceErrorEnums implements BaseBizError {

  /**
   * 三方异常
   */
  PARAMS_ERROR("【参数错误】${message}"),
  THIRD_ERROR("【三方异常】${message}"),
  BIZ_ERROR("【业务错误】${message}"),
  REPEAT_SUBMIT("请勿重复提交"),
  NOT_EXIST("数据不存在"),
  NOT_SUPPORT_METHOD("不支持的方法"),
  NOT_SUPPORT_TYPE("不支持的类型"),
  CHANNEL_NOT_OPEN("未开通当前支付通道"),
  MERCHANT_NOT_OPEN("未进件"),
  NOT_SUPPORT_FILE_TYPE("不支持的文件类型"),
  EXIST_PROCESS_APPLY("存在处理中的申请"),
  EXIST_BIND_RECORD("存在已经绑定的流水"),
  PAY_FAIL("{0}"),
  PAY_FAIL_1("支付失败，请联系场馆工作人员处理。"),
  PAY_FAIL_2("收款账户状态异常，请联系场馆工作人员处理。"),
  PAY_FAIL_3("网络异常支付失败，请重新支付。"),
  PAY_FAIL_4("支付失败，请联系场馆工作人员进行微信授权。"),
  PAY_FAIL_5("支付失败，请联系场馆工作人员进行支付宝授权。"),
  PAY_FAIL_6("该场馆单笔收款有额度限制，请联系场馆提升收款额度或者分多笔订单支付。"),
  PAY_FAIL_7("该场馆单日收款有额度限制，请联系场馆提升收款额度。"),
  PAY_FAIL_8("金额必须大于0元"),
  PAY_FAIL_9("金额必须小于10000000元"),
  PAY_FAIL_10("未开通线上支付，请联系场馆工作人员处理"),

  ;

  @Getter
  private final String module = "PAY_CENTER";

  @Getter
  private final String code = name();

  @Getter
  private final String defaultMessage;

  FinanceErrorEnums(String defaultMessage) {
    this.defaultMessage = defaultMessage;
  }

}
