package com.jiejing.fitness.finance.service.pay.convert;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.common.utils.crypt.AesUtil;
import com.jiejing.fitness.finance.repository.entity.MerchantSettleRecord;
import com.jiejing.fitness.finance.repository.entity.StudioCheckSettleRecord;
import com.jiejing.fitness.finance.repository.entity.StudioMerchantApply;
import com.jiejing.fitness.finance.repository.entity.StudioSettleRecord;
import com.jiejing.fitness.finance.service.utils.MoneyUtil;
import com.jiejing.paycenter.common.enums.common.TransStateEnums;
import com.jiejing.paycenter.common.model.vo.SettleVO;
import com.jiejing.studio.api.studio.vo.StudioVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author chengyubing
 * @since 2024/5/7 16:48
 */
public class SettleConvert {

  public static MerchantSettleRecord convertMerchantSettle(StudioMerchantApply apply, SettleVO vo) {
    String salt = AesUtil.getSalt(8);
    Date now = new Date();
    return MerchantSettleRecord.builder()
        .id(IdWorker.getId())
        .merchantId(apply.getMerchantId())
        .merchantNo(apply.getMerchantNo())
        .transState(vo.getTransState())
        .transAmount(vo.getTransAmount())
        .settleDate(vo.getTransDate())
        .cardNo(AesUtil.encrypt(salt, vo.getCardNo()))
        .bankName(vo.getBankName())
        .failMsg(vo.getFailMsg())
        .salt(salt)
        .createTime(now)
        .updateTime(now).build();
  }

  public static MerchantSettleRecord convertMerchantSettle(MerchantSettleRecord history, SettleVO vo) {
    return MerchantSettleRecord.builder()
        .id(history.getId())
        .transState(vo.getTransState())
        .failMsg(vo.getFailMsg())
        .updateTime(new Date()).build();
  }

  public static StudioSettleRecord convertStudioSettle(MerchantSettleRecord history, SettleVO vo) {
    return StudioSettleRecord.builder()
        .parentId(history.getId())
        .transState(vo.getTransState())
        .failMsg(vo.getFailMsg())
        .updateTime(new Date()).build();
  }

  public static List<StudioSettleRecord> convertStudioSettle(MerchantSettleRecord record,
      Map<Long, BigDecimal> studioPayAmountMap, Map<Long, BigDecimal> studioRefundAmountMap,
      Map<Long, StudioVO> studioMap) {
    // A场馆支付了100，B场馆支付了0，B场馆发起退款-》成功。结算记录-》
    // A场馆支付了0，B场馆支付了0，B场馆发起退款-》失败
    // A场馆支付了100，B场馆支付了0，B场馆发起退款-》成功，A场馆发起退款100-》失败
    return studioPayAmountMap.keySet().stream().map(studioId -> StudioSettleRecord.builder()
        .id(IdWorker.getId())
        .parentId(record.getId())
        .studioId(studioId)
        .studioName(Optional.ofNullable(studioMap.get(studioId)).map(StudioVO::getName).orElse("-"))
        .merchantId(record.getMerchantId())
        .merchantNo(record.getMerchantNo())
        .transState(record.getTransState())
        .transAmount(MoneyUtil.subtract(studioPayAmountMap.getOrDefault(studioId, BigDecimal.ZERO),
            studioRefundAmountMap.getOrDefault(studioId, BigDecimal.ZERO)))
        .settleDate(record.getSettleDate())
        .cardNo(record.getCardNo())
        .bankName(record.getBankName())
        .failMsg(record.getFailMsg())
        .salt(record.getSalt())
        .createTime(record.getCreateTime())
        .updateTime(record.getUpdateTime())
        .build()).collect(Collectors.toList());
  }

  public static StudioCheckSettleRecord convertCheckSettle(StudioMerchantApply apply, SettleVO vo,
      BigDecimal totalAmount) {
    return StudioCheckSettleRecord.builder()
        .id(IdWorker.getId())
        .merchantId(apply.getMerchantId())
        .merchantNo(apply.getMerchantNo())
        .checkState(TransStateEnums.FAIL.getCode())
        .failMsg("对账失败，乐动收银入账中金额【" + totalAmount + "】，汇付结算金额【" + vo.getTransAmount() + "】")
        .settleDate(vo.getTransDate())
        .createTime(new Date())
        .updateTime(new Date())
        .build();
  }


}
