package com.jiejing.fitness.finance.service.pay.impl;

import com.jiejing.common.exception.BizException;
import com.jiejing.fitness.finance.repository.entity.StudioCashierRecord;
import com.jiejing.fitness.finance.repository.service.StudioCashierRecordRpService;
import com.jiejing.fitness.finance.service.enums.FinanceErrorEnums;
import com.jiejing.fitness.finance.service.pay.RefundService;
import com.jiejing.fitness.finance.service.pay.convert.RefundConvert;
import com.jiejing.fitness.finance.service.pay.params.StudioMerchantRefundParams;
import com.jiejing.fitness.finance.service.rpc.PayRpcService;
import com.jiejing.paycenter.api.pay.request.RefundPayRequest;
import com.jiejing.paycenter.common.event.RefundEvent;
import com.jiejing.paycenter.common.model.vo.RefundVO;
import java.math.BigDecimal;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

/**
 * @author chengyubing
 * @since 2024/5/7 16:37
 */
@Slf4j
@Service
public class RefundServiceImpl implements RefundService {

  @Resource
  private PayRpcService payRpcService;

  @Resource
  private StudioCashierRecordRpService studioCashierRecordRpService;

  @Resource
  private TransactionTemplate transactionTemplate;

  @Override
  public RefundVO merchantRefund(StudioMerchantRefundParams params) {
    StudioCashierRecord refund = transactionTemplate.execute(action -> {
      Long payId = Long.parseLong(params.getPayTransNo());
      StudioCashierRecord pay = studioCashierRecordRpService.getById(payId)
          .orElseThrow(() -> new BizException(FinanceErrorEnums.NOT_EXIST));

      BigDecimal historyRefundActualAmount = studioCashierRecordRpService.sumRefundActualAmountByPayTransNo(
          params.getPayTransNo());

      StudioCashierRecord record = RefundConvert.convertRefundInit(params, pay, historyRefundActualAmount);
      studioCashierRecordRpService.insert(record);
      return record;
    });

    RefundPayRequest request = RefundConvert.convert(params, refund);
    RefundVO vo = payRpcService.refund(request);

    StudioCashierRecord toModify = RefundConvert.convertRefund(refund, vo);
    studioCashierRecordRpService.updateById(toModify);
    return vo;
  }

  @Override
  public void refundCallback(RefundEvent event) {
    StudioCashierRecord record = studioCashierRecordRpService.getById(Long.parseLong(event.getTransNo()))
        .orElse(null);
    if (null == record) {
      return;
    }

    StudioCashierRecord toModify = RefundConvert.convertRefund(record, event);
    studioCashierRecordRpService.updateById(toModify);
  }

}
