package com.jiejing.fitness.finance.api.config;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.config.request.GetConfigRequest;
import com.jiejing.fitness.finance.api.merchant.BrandMerchantApiFallback;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/6/4 11:22
 */
@Component
public class FinanceConfigApiFallback implements FallbackFactory<FinanceConfigApi> {

  @Override
  public FinanceConfigApi create(Throwable throwable) {
    return new FinanceConfigApi() {
      @Override
      public JsonResult<JSONObject> get(GetConfigRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
