package com.jiejing.fitness.finance.app.controller;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.service.merchant.StudioMerchantService;
import com.jiejing.paycenter.api.merchant.MerchantQueryApi;
import com.jiejing.paycenter.common.event.MerchantEvent;

import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/26 10:01
 */
@RestController
public class TestController {

  @Resource
  private MerchantQueryApi merchantApi;

  private StudioMerchantService studioMerchantService;


  @PostMapping(value = "/private/test/merchantCallback")
  public JsonResult<Map<Long, BigDecimal>> merchantCallback(@RequestBody MerchantEvent event) {
    studioMerchantService.callback(event);
    return JsonResult.success();
  }


  private String getSuffix(String url) {
    String[] split = url.split("\\?");
    String fileName = StringUtils.substringAfterLast(split[0], "/");
    String[] names = fileName.split("\\.");
    return "." + names[names.length - 1];
  }

}
