package com.jiejing.fitness.finance.api.axf.vo;

import com.jiejing.fitness.finance.api.axf.enums.AxfOrderSignStateEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/12 15:31
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "订购单VO")
public class StudioAxfOrderVO {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "渠道号")
  private String channelNo;

  @ApiModelProperty(value = "商户ID")
  private Long merchantId;

  @ApiModelProperty(value = "商户号")
  private String merchantNo;

  @ApiModelProperty(value = "商品ID")
  private Long commodityId;

  @ApiModelProperty(value = "学员ID")
  private Long studentId;

  @ApiModelProperty(value = "学员姓名")
  private String studentName;

  @ApiModelProperty(value = "学员手机号")
  private String studentPhone;

  @ApiModelProperty(value = "签约状态")
  private String signState;

  @ApiModelProperty(value = "总期数")
  private Integer totalPeriod;

  @ApiModelProperty(value = "总原价（签约扣款金额）：元")
  private BigDecimal originalPrice;

  @ApiModelProperty(value = "售价：元")
  private BigDecimal salePrice;

  @ApiModelProperty(value = "已扣款金额：元")
  private BigDecimal receivedAmount;

  @ApiModelProperty(value = "已扣款手续费：元")
  private BigDecimal receivedFee;

  @ApiModelProperty(value = "已扣款实收金额：元")
  private BigDecimal receivedActualAmount;

  @ApiModelProperty(value = "当前扣款期数")
  private Integer receivedPeriod;

  @ApiModelProperty(value = "手续费率：%")
  private BigDecimal rate;

  @ApiModelProperty(value = "订单ID")
  private Long voucherId;

  @ApiModelProperty(value = "订单号：冗余字段")
  private String voucherBusinessNo;

  @ApiModelProperty(value = "支付宝订购单号")
  private String thirdOrderNo;

  @ApiModelProperty(value = "解约人ID")
  private Long cancelOpId;

  @ApiModelProperty(value = "解约人姓名")
  private String cancelOpName;

  @ApiModelProperty(value = "解约失败信息")
  private String cancelFailMessage;

  @ApiModelProperty(value = "解约时间")
  private Date cancelTime;

  @ApiModelProperty(value = "签约时间")
  private Date signTime;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;

  @ApiModelProperty(value = "商品")
  private StudioAxfCommodityVO commodity;

}
