/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 机构安心付申请记录
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioAxfApply implements Serializable {

  private static final long serialVersionUID = -166947593419927514L;

  /**
   * 备注: 主键 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 渠道号 默认值: 001 是否允许为null: NO
   */
  private String channelNo;

  /**
   * 备注: 支付宝pid/userid 是否允许为null: NO
   */
  private String merchantNo;

  /**
   * 备注: 商户ID 是否允许为null: YES
   */
  private Long merchantId;

  /**
   * 备注: 场馆ID 是否允许为null: NO
   */
  private Long studioId;

  /**
   * 备注: 品牌ID 是否允许为null: NO
   */
  private Long brandId;

  /**
   * 备注: 操作类型 默认值: OPEN 是否允许为null: YES
   */
  private String applyType;

  /**
   * 备注: 场馆名称 是否允许为null: YES
   */
  private String studioName;

  /**
   * 备注: 商户名称 是否允许为null: YES
   */
  private String merchantName;

  /**
   * 备注: 商户简称 是否允许为null: NO
   */
  private String shortName;

  /**
   * 备注: 企业类型：+ PRIVATE: 私营企业+ PERSONAL: 个体工商户 是否允许为null: YES
   */
  private String companyType;

  /**
   * 备注: 开通状态：+ INIT: 初始+ AXF_PROCESS: 安心付开通中+ AXF_SUCCESS: 安心付开通成功+ STORE_PROCESS: 门店开通中+ STORE_SUCCESS:
   * 门店开通成功 是否允许为null: NO
   */
  private String state;

  /**
   * 备注: 结算账户号 是否允许为null: YES
   */
  private String cardNo;

  /**
   * 备注: 营业执照编号 是否允许为null: NO
   */
  private String licenseCode;

  /**
   * 备注: 营业执照名称 是否允许为null: NO
   */
  private String licenseName;

  /**
   * 备注: 营业执照类型 是否允许为null: YES
   */
  private String licenseType;

  /**
   * 备注: 营业执照有效期类型 是否允许为null: YES
   */
  private String licenseExpireType;

  /**
   * 备注: 营业执照有效期开始时间 是否允许为null: YES
   */
  private Date licenseStartTime;

  /**
   * 备注: 营业执照有效期结束时间 是否允许为null: YES
   */
  private Date licenseEndTime;

  /**
   * 备注: 法人姓名 是否允许为null: YES
   */
  private String legalName;

  /**
   * 备注: 法人证件号 是否允许为null: YES
   */
  private String legalCertNo;

  /**
   * 备注: 联系人手机号 是否允许为null: YES
   */
  private String phone;

  /**
   * 备注: 经营地址-省份code 是否允许为null: YES
   */
  private String businessProvinceCode;

  /**
   * 备注: 经营地址-省份名称 是否允许为null: YES
   */
  private String businessProvinceName;

  /**
   * 备注: 经营地址城市code 是否允许为null: YES
   */
  private String businessCityCode;

  /**
   * 备注: 经营地址城市名称 是否允许为null: YES
   */
  private String businessCityName;

  /**
   * 备注: 经营地址县区code 是否允许为null: YES
   */
  private String businessDistrictCode;

  /**
   * 备注: 经营地址县区名称 是否允许为null: YES
   */
  private String businessDistrictName;

  /**
   * 备注: 经营详细地址 是否允许为null: YES
   */
  private String businessAddress;

  /**
   * 备注: 营业执照资源ID 是否允许为null: YES
   */
  private Long licenseResourceId;

  /**
   * 备注: 门头照资源ID 是否允许为null: YES
   */
  private Long storeHeadResourceId;

  /**
   * 备注: 失败原因 是否允许为null: YES
   */
  private String failMessage;

  /**
   * 备注: 操作人ID 默认值: -1 是否允许为null: YES
   */
  private Long opId;

  /**
   * 备注: 操作人姓名 是否允许为null: YES
   */
  private String opName;

  /**
   * 备注: 盐 是否允许为null: YES
   */
  private String salt;

  /**
   * 备注: 创建时间 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更细时间 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String CHANNEL_NO = "channel_no";

  public static final String MERCHANT_NO = "merchant_no";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String STUDIO_ID = "studio_id";

  public static final String BRAND_ID = "brand_id";

  public static final String APPLY_TYPE = "apply_type";

  public static final String STUDIO_NAME = "studio_name";

  public static final String MERCHANT_NAME = "merchant_name";

  public static final String SHORT_NAME = "short_name";

  public static final String COMPANY_TYPE = "company_type";

  public static final String STATE = "state";

  public static final String CARD_NO = "card_no";

  public static final String LICENSE_CODE = "license_code";

  public static final String LICENSE_NAME = "license_name";

  public static final String LICENSE_TYPE = "license_type";

  public static final String LICENSE_EXPIRE_TYPE = "license_expire_type";

  public static final String LICENSE_START_TIME = "license_start_time";

  public static final String LICENSE_END_TIME = "license_end_time";

  public static final String LEGAL_NAME = "legal_name";

  public static final String LEGAL_CERT_NO = "legal_cert_no";

  public static final String PHONE = "phone";

  public static final String BUSINESS_PROVINCE_CODE = "business_province_code";

  public static final String BUSINESS_PROVINCE_NAME = "business_province_name";

  public static final String BUSINESS_CITY_CODE = "business_city_code";

  public static final String BUSINESS_CITY_NAME = "business_city_name";

  public static final String BUSINESS_DISTRICT_CODE = "business_district_code";

  public static final String BUSINESS_DISTRICT_NAME = "business_district_name";

  public static final String BUSINESS_ADDRESS = "business_address";

  public static final String LICENSE_RESOURCE_ID = "license_resource_id";

  public static final String STORE_HEAD_RESOURCE_ID = "store_head_resource_id";

  public static final String FAIL_MESSAGE = "fail_message";

  public static final String OP_ID = "op_id";

  public static final String OP_NAME = "op_name";

  public static final String SALT = "salt";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
