/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 先享后付订购单
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioAxfOrder implements Serializable {

  private static final long serialVersionUID = -166947593419927514L;

  /**
   * 备注: 主键
   * 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 场馆ID
   * 是否允许为null: YES
   */
  private Long studioId;

  /**
   * 备注: 渠道号
   * 默认值: 001
   * 是否允许为null: YES
   */
  private String channelNo;

  /**
   * 备注: 商户ID
   * 是否允许为null: YES
   */
  private Long merchantId;


  /**
   * 备注: 支付宝pid/userid
   * 是否允许为null: No
   */
  private String merchantNo;

  /**
   * 备注: 商品ID
   * 是否允许为null: YES
   */
  private Long commodityId;

  /**
   * 备注: 学员ID
   * 是否允许为null: YES
   */
  private Long studentId;

  /**
   * 备注: 学员姓名
   * 是否允许为null: YES
   */
  private String studentName;

  /**
   * 备注: 签约状态
   * 是否允许为null: YES
   */
  private String signState;

  /**
   * 备注: 总期数
   * 是否允许为null: YES
   */
  private Integer totalPeriod;

  /**
   * 备注: 总原价（签约扣款金额）：元
   * 是否允许为null: YES
   */
  private BigDecimal originalPrice;

  /**
   * 备注: 售价：元
   * 是否允许为null: YES
   */
  private BigDecimal salePrice;

  /**
   * 备注: 已扣款金额：元
   * 是否允许为null: YES
   */
  private BigDecimal receivedAmount;

  /**
   * 备注: 已扣款手续费：元
   * 是否允许为null: YES
   */
  private BigDecimal receivedFee;

  /**
   * 备注: 已扣款实收金额：元
   * 是否允许为null: YES
   */
  private BigDecimal receivedActualAmount;

  /**
   * 备注: 当前扣款期数
   * 是否允许为null: YES
   */
  private Integer receivedPeriod;

  /**
   * 备注: 手续费率：%
   * 是否允许为null: YES
   */
  private BigDecimal rate;

  /**
   * 备注: 订单ID
   * 是否允许为null: YES
   */
  private Long voucherId;

  /**
   * 备注: 订单号：冗余字段
   * 是否允许为null: YES
   */
  private String voucherBusinessNo;

  /**
   * 备注: 支付宝订购单号
   * 是否允许为null: YES
   */
  private String thirdOrderNo;

  /**
   * 备注: 解约人ID
   * 是否允许为null: YES
   */
  private Long cancelOpId;

  /**
   * 备注: 解约人姓名
   * 是否允许为null: YES
   */
  private String cancelOpName;

  /**
   * 备注: 解约失败
   * 是否允许为null: YES
   */
  private String cancelFailMessage;

  /**
   * 备注: 订单的其他属性
   * 是否允许为null: YES
   */
  private String attr;

  /**
   * 备注: 解约时间
   * 是否允许为null: YES
   */
  private Date cancelTime;

  /**
   * 备注: 签约时间
   * 是否允许为null: YES
   */
  private Date signTime;

  /**
   * 备注: 创建时间
   * 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间
   * 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String STUDIO_ID = "studio_id";

  public static final String CHANNEL_NO = "channel_no";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String MERCHANT_NO = "merchant_no";

  public static final String COMMODITY_ID = "commodity_id";

  public static final String STUDENT_ID = "student_id";

  public static final String STUDENT_NAME = "student_name";

  public static final String SIGN_STATE = "sign_state";

  public static final String TOTAL_PERIOD = "total_period";

  public static final String ORIGINAL_PRICE = "original_price";

  public static final String SALE_PRICE = "sale_price";

  public static final String RECEIVED_AMOUNT = "received_amount";

  public static final String RECEIVED_FEE = "received_fee";

  public static final String RECEIVED_ACTUAL_AMOUNT = "received_actual_amount";

  public static final String RECEIVED_PERIOD = "received_period";

  public static final String RATE = "rate";

  public static final String VOUCHER_ID = "voucher_id";

  public static final String VOUCHER_BUSINESS_NO = "voucher_business_no";

  public static final String THIRD_ORDER_NO = "third_order_no";

  public static final String CANCEL_OP_ID = "cancel_op_id";

  public static final String CANCEL_OP_NAME = "cancel_op_name";

  public static final String CANCEL_FAIL_MESSAGE = "cancel_fail_message";

  public static final String ATTR = "attr";

  public static final String CANCEL_TIME = "cancel_time";

  public static final String SIGN_TIME = "sign_time";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
