/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jiejing.fitness.finance.api.axf.enums.AxfOrderSignStateEnums;
import com.jiejing.fitness.finance.api.axf.vo.AggStudioAxfOrderVO;
import com.jiejing.fitness.finance.repository.entity.StudioAxfOrder;
import com.jiejing.fitness.finance.repository.mapper.StudioAxfOrderMapper;
import com.jiejing.mbp.MapperRepoService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 先享后付订购单 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Service
public class StudioAxfOrderRpService extends MapperRepoService<Long, StudioAxfOrder, StudioAxfOrderMapper> {

  public StudioAxfOrder getByVoucherId(Long voucherId) {
    QueryWrapper<StudioAxfOrder> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioAxfOrder.VOUCHER_ID, voucherId);
    wrapper.orderByAsc(StudioAxfOrder.ID);
    return this.baseMapper.selectPage(new Page<>(0, 1), wrapper).getRecords().stream().findFirst()
        .orElse(null);
  }

  public org.springframework.data.domain.Page<StudioAxfOrder> page(List<Long> studioIds, Long studentId,
      String studentName, String merchantNo,
      String voucherBusinessNo, String thirdOrderNo, Date signTimeStart, Date signTimeEnd,
      Date cancelTimeStart, Date cancelTimeEnd, AxfOrderSignStateEnums state, Integer current, Integer size) {
    QueryWrapper<StudioAxfOrder> wrapper = new QueryWrapper<>();
    if (CollectionUtils.isNotEmpty(studioIds)) {
      wrapper.in(StudioAxfOrder.STUDIO_ID, studioIds);
    }
    if (null != studentId) {
      wrapper.eq(StudioAxfOrder.STUDENT_ID, studentId);
    }
    if (StringUtils.isNotEmpty(studentName)) {
      wrapper.eq(StudioAxfOrder.STUDENT_NAME, studentName);
    }
    if (StringUtils.isNotEmpty(merchantNo)){
      wrapper.eq(StudioAxfOrder.MERCHANT_NO, merchantNo);
    }
    if (StringUtils.isNotEmpty(voucherBusinessNo)) {
      wrapper.eq(StudioAxfOrder.VOUCHER_BUSINESS_NO, voucherBusinessNo);
    }
    if (StringUtils.isNotEmpty(thirdOrderNo)) {
      wrapper.eq(StudioAxfOrder.THIRD_ORDER_NO, thirdOrderNo);
    }
    if (null != state) {
      wrapper.eq(StudioAxfOrder.SIGN_STATE, state);
    }
    if (null != signTimeStart) {
      wrapper.ge(StudioAxfOrder.SIGN_TIME, signTimeStart);
    }
    if (null != signTimeEnd) {
      wrapper.le(StudioAxfOrder.SIGN_TIME, signTimeEnd);
    }
    if (null != cancelTimeStart) {
      wrapper.ge(StudioAxfOrder.CANCEL_TIME, cancelTimeStart);
    }
    if (null != cancelTimeEnd) {
      wrapper.le(StudioAxfOrder.CANCEL_TIME, cancelTimeEnd);
    }
    wrapper.orderByDesc(StudioAxfOrder.ID);
    return this.findByWrapperPage(wrapper, current, size);
  }

  public StudioAxfOrder getByThirdOrderNo(Long merchantId, String thirdOrderNo) {
    QueryWrapper<StudioAxfOrder> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioAxfOrder.MERCHANT_ID, merchantId);
    wrapper.eq(StudioAxfOrder.THIRD_ORDER_NO, thirdOrderNo);
    return this.baseMapper.selectPage(new Page<>(0, 1), wrapper).getRecords().stream().findFirst()
        .orElse(null);
  }

  public AggStudioAxfOrderVO agg(List<Long> studioIds, Long studentId, String studentName,
      String voucherBusinessNo, String thirdOrderNo, Date signTimeStart, Date signTimeEnd,
      Date cancelTimeStart, Date cancelTimeEnd, AxfOrderSignStateEnums state) {
    AggStudioAxfOrderVO vo = this.baseMapper.agg(studioIds, studentId, studentName, voucherBusinessNo,
        thirdOrderNo, signTimeStart, signTimeEnd, cancelTimeStart, cancelTimeEnd, state);
    if (null == vo) {
      return AggStudioAxfOrderVO.builder().receivedActualAmount(BigDecimal.ZERO)
          .receivedAmount(BigDecimal.ZERO)
          .build();
    }
    vo.setReceivedActualAmount(
        vo.getReceivedActualAmount() == null ? BigDecimal.ZERO : vo.getReceivedActualAmount());
    vo.setReceivedAmount(vo.getReceivedAmount() == null ? BigDecimal.ZERO : vo.getReceivedAmount());
    return vo;
  }
}
