package com.jiejing.fitness.finance.api.axf.vo;

import com.jiejing.common.enums.ConfirmEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/5 15:16
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "场馆安心付授权VO")
public class StudioAuthTokenVO {

  @ApiModelProperty("ID")
  private Long id;

  @ApiModelProperty("本次授权是否已经完成进件")
  private ConfirmEnum used;

  @ApiModelProperty("appAuthToken")
  private String appAuthToken;

  @ApiModelProperty("appRefreshToken")
  private String appRefreshToken;

  @ApiModelProperty("authAppId")
  private String authAppId;

  @ApiModelProperty("expiresIn")
  private String expiresIn;

  @ApiModelProperty("reExpiresIn")
  private String reExpiresIn;

  @ApiModelProperty("userId")
  private String userId;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("更新时间")
  private Date updateTime;

}
