package com.jiejing.fitness.finance.app.config;

import java.util.concurrent.ThreadPoolExecutor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 * @author chengyubing
 * @since 2024/2/18 17:04
 */
@Slf4j
@Configuration
public class FinanceAsyncConfiguration {

  @Bean(value = "financeAsyncConfiguration")
  public AsyncTaskExecutor payCenterThreadPool() {
    ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
    executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 8);
    executor.setMaxPoolSize(Runtime.getRuntime().availableProcessors() * 16);
    executor.setQueueCapacity(120);
    executor.setKeepAliveSeconds(60);
    executor.setThreadNamePrefix("financeThreadPool-");
    executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
    executor.initialize();
    return executor;
  }

}
