/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.jiejing.fitness.finance.api.enums.ApplyTypeEnums;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.CardTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CertTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 品牌商户申请表（M端以及B端数据回显用，支付以及各状态判断、商户号不使用此表）
 * </p>
 *
 * @author chengyubing, created on 2024-02-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class BrandMerchantApply implements Serializable {

  private static final long serialVersionUID = 8208543338007620669L;

  /**
   * ID
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 品牌ID
   */
  private Long brandId;

  /**
   * 场馆ID
   */
  private Long studioId;

  /**
   * 申请单号
   */
  private String applyNo;

  /**
   * 申请类型：OPEN-进件；RE_OPEN-重进件；
   */
  private ApplyTypeEnums applyType;

  /**
   * 渠道号
   */
  private String channelNo;

  /**
   * 商户号
   */
  private String merchantNo;

  /**
   * 商户名称
   */
  private String merchantName;

  /**
   * 商户简称
   */
  private String shortName;

  /**
   * 企业类型
   */
  private CompanyTypeEnums companyType;

  /**
   * 开通状态：I-初始态；P-处理中；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums openState;

  /**
   * 开通失败原因
   */
  private String openFailMessage;

  /**
   * 支付宝开通状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums aliOpenState;

  /**
   * 支付宝商户号
   */
  private String aliMerchantNo;

  /**
   * 支付宝开通失败原因
   */
  private String aliOpenFailMessage;

  /**
   * 微信线下通道开通状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOfflineOpenState;

  /**
   * 微信线下通道认证状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOfflineAuthState;

  /**
   * 微信线下通道商户号
   */
  private String wxOfflineMerchantNo;

  /**
   * 微信线下通道开通失败原因
   */
  private String wxOfflineOpenFailMessage;

  /**
   * 微信线上通道开通状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOnlineOpenState;

  /**
   * 微信线上通道认证状态：I-初始态；S-成功；F-失败 默认值: I
   */
  private OpenStateEnums wxOnlineAuthState;

  /**
   * 微信线上通道商户号
   */
  private String wxOnlineMerchantNo;

  /**
   * 微信线下通道开通失败原因
   */
  private String wxOnlineOpenFailMessage;

  /**
   * 经营地址：省
   */
  private String businessProvince;

  /**
   * 经营地址：市
   */
  private String businessCity;

  /**
   * 经营地址：区
   */
  private String businessDistrict;

  /**
   * 商户经营详细地址
   */
  private String businessAddress;

  /**
   * 营业执照号
   */
  private String licenseCode;

  /**
   * 营业执照有效期类型
   */
  private ExpireTypeEnums licenseExpireType;

  /**
   * 营业执照有效期开始日期
   */
  private Date licenseStartDate;

  /**
   * 营业执照有效期截止日期
   */
  private Date licenseEndDate;

  /**
   * 营业护照规定的经营范围
   */
  private String licenseBusinessScope;

  /**
   * 营业执照创办日期
   */
  private Date licenseFoundDate;

  /**
   * 商户经营地址：省
   */
  private String licenseProvince;

  /**
   * 商户经营地址：市
   */
  private String licenseCity;

  /**
   * 商户经营地址：区
   */
  private String licenseDistrict;

  /**
   * 营业执照注册详细地址
   */
  private String licenseAddress;

  /**
   * 法人姓名
   */
  private String legalName;

  /**
   * 法人证件号码
   */
  private String legalCertNo;

  /**
   * 法人证件类型
   */
  private CertTypeEnums legalCertType;

  /**
   * 法人证件有效期类型
   */
  private ExpireTypeEnums legalCertExpireType;

  /**
   * 法人证件有效期开始日期
   */
  private Date legalCertStartDate;

  /**
   * 法人证件有效期截止日期
   */
  private Date legalCertEndDate;

  /**
   * 法人手机号
   */
  private String legalPhone;

  /**
   * 法人证件地址：省
   */
  private String legalProvince;

  /**
   * 法人证件地址：市
   */
  private String legalCity;

  /**
   * 法人证件地址：区
   */
  private String legalDistrict;

  /**
   * 法人证件详细地址
   */
  private String legalAddress;

  /**
   * 联系人邮箱
   */
  private String contactEmail;

  /**
   * 结算卡类型：对公卡、对私卡
   */
  private CardTypeEnums bankCardType;

  /**
   * 结算卡卡号
   */
  private String bankCardNo;

  /**
   * 银行卡账户名（对私卡：持卡人姓名；对公卡：营业执照名称）
   */
  private String bankCardName;

  /**
   * 持卡人手机号（对私卡必填）
   */
  private String bankPhone;

  /**
   * 结算卡证件号码（对私卡：持卡人身份证；对公卡：营业执照号）
   */
  private String bankCertNo;

  /**
   * 结算卡持卡人证件类型
   */
  private CertTypeEnums bankCertType;

  /**
   * 证件有效期类型，对私卡必填
   */
  private ExpireTypeEnums bankCertExpireType;

  /**
   * 持卡人证件有效期开始日期，对私卡必填
   */
  private Date bankCertStartDate;

  /**
   * 持卡人证件有效期截止日期
   */
  private Date bankCertEndDate;

  /**
   * 基本存款账户编号
   */
  private String bankBaseDepositNo;

  /**
   * 银行编码
   */
  private String bankCode;

  /**
   * bankName
   */
  private String bankName;

  /**
   * 支行名称
   */
  private String bankBranchName;

  /**
   * 支行号
   */
  private String bankBranchCode;

  /**
   * 结算卡开卡地址：省
   */
  private String bankCardProvince;

  /**
   * 结算卡开卡地址：市
   */
  private String bankCardCity;

  /**
   * 结算卡开卡地址：区
   */
  private String bankCardDistrict;

  /**
   * 结算卡开卡详细地址
   */
  private String bankCardAddress;

  /**
   * 资源信息
   */
  private String resourceInfo;

  /**
   * 盐
   */
  private String salt;

  /**
   * 完成时间
   */
  private Date finishTime;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 更新时间
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String BRAND_ID = "brand_id";

  public static final String STUDIO_ID = "studio_id";

  public static final String APPLY_NO = "apply_no";

  public static final String APPLY_TYPE = "apply_type";

  public static final String CHANNEL_NO = "channel_no";

  public static final String MERCHANT_NO = "merchant_no";

  public static final String MERCHANT_NAME = "merchant_name";

  public static final String SHORT_NAME = "short_name";

  public static final String COMPANY_TYPE = "company_type";

  public static final String OPEN_STATE = "open_state";

  public static final String OPEN_FAIL_MESSAGE = "open_fail_message";

  public static final String ALI_OPEN_STATE = "ali_open_state";

  public static final String ALI_MERCHANT_NO = "ali_merchant_no";

  public static final String ALI_OPEN_FAIL_MESSAGE = "ali_open_fail_message";

  public static final String WX_OFFLINE_OPEN_STATE = "wx_offline_open_state";

  public static final String WX_OFFLINE_AUTH_STATE = "wx_offline_auth_state";

  public static final String WX_OFFLINE_MERCHANT_NO = "wx_offline_merchant_no";

  public static final String WX_OFFLINE_OPEN_FAIL_MESSAGE = "wx_offline_open_fail_message";

  public static final String WX_ONLINE_OPEN_STATE = "wx_online_open_state";

  public static final String WX_ONLINE_AUTH_STATE = "wx_online_auth_state";

  public static final String WX_ONLINE_MERCHANT_NO = "wx_online_merchant_no";

  public static final String WX_ONLINE_OPEN_FAIL_MESSAGE = "wx_online_open_fail_message";

  public static final String BUSINESS_PROVINCE = "business_province";

  public static final String BUSINESS_CITY = "business_city";

  public static final String BUSINESS_DISTRICT = "business_district";

  public static final String BUSINESS_ADDRESS = "business_address";

  public static final String LICENSE_CODE = "license_code";

  public static final String LICENSE_EXPIRE_TYPE = "license_expire_type";

  public static final String LICENSE_START_DATE = "license_start_date";

  public static final String LICENSE_END_DATE = "license_end_date";

  public static final String LICENSE_BUSINESS_SCOPE = "license_business_scope";

  public static final String LICENSE_FOUND_DATE = "license_found_date";

  public static final String LICENSE_PROVINCE = "license_province";

  public static final String LICENSE_CITY = "license_city";

  public static final String LICENSE_DISTRICT = "license_district";

  public static final String LICENSE_ADDRESS = "license_address";

  public static final String LEGAL_NAME = "legal_name";

  public static final String LEGAL_CERT_NO = "legal_cert_no";

  public static final String LEGAL_CERT_TYPE = "legal_cert_type";

  public static final String LEGAL_CERT_EXPIRE_TYPE = "legal_cert_expire_type";

  public static final String LEGAL_CERT_START_DATE = "legal_cert_start_date";

  public static final String LEGAL_CERT_END_DATE = "legal_cert_end_date";

  public static final String LEGAL_PHONE = "legal_phone";

  public static final String LEGAL_PROVINCE = "legal_province";

  public static final String LEGAL_CITY = "legal_city";

  public static final String LEGAL_DISTRICT = "legal_district";

  public static final String LEGAL_ADDRESS = "legal_address";

  public static final String CONTACT_EMAIL = "contact_email";

  public static final String BANK_CARD_TYPE = "bank_card_type";

  public static final String BANK_CARD_NO = "bank_card_no";

  public static final String BANK_CARD_NAME = "bank_card_name";

  public static final String BANK_PHONE = "bank_phone";

  public static final String BANK_CERT_NO = "bank_cert_no";

  public static final String BANK_CERT_TYPE = "bank_cert_type";

  public static final String BANK_CERT_EXPIRE_TYPE = "bank_cert_expire_type";

  public static final String BANK_CERT_START_DATE = "bank_cert_start_date";

  public static final String BANK_CERT_END_DATE = "bank_cert_end_date";

  public static final String BANK_BASE_DEPOSIT_NO = "bank_base_deposit_no";

  public static final String BANK_CODE = "bank_code";

  public static final String BANK_NAME = "bank_name";

  public static final String BANK_BRANCH_NAME = "bank_branch_name";

  public static final String BANK_BRANCH_CODE = "bank_branch_code";

  public static final String BANK_CARD_PROVINCE = "bank_card_province";

  public static final String BANK_CARD_CITY = "bank_card_city";

  public static final String BANK_CARD_DISTRICT = "bank_card_district";

  public static final String BANK_CARD_ADDRESS = "bank_card_address";

  public static final String RESOURCE_INFO = "resource_info";

  public static final String SALT = "salt";

  public static final String FINISH_TIME = "finish_time";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
