package com.jiejing.fitness.finance.service.merchant.impl;

import com.jiejing.fitness.finance.repository.entity.BrandMerchantApply;
import com.jiejing.fitness.finance.repository.service.BrandMerchantApplyRpService;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.fitness.finance.service.merchant.convert.MerchantConvert;
import com.jiejing.fitness.finance.service.merchant.params.ApplyBrandMerchantParams;
import com.jiejing.fitness.finance.service.rpc.MerchantRpcService;
import com.jiejing.fitness.finance.service.rpc.StudioRpcService;
import com.jiejing.paycenter.api.merchant.request.ApplyMerchantRequest;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.studio.api.studio.vo.StudioVO;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 品牌商户服务
 *
 * @author chengyubing
 * @since 2024/2/20 14:01
 */
@Slf4j
@Service
public class BrandMerchantServiceImpl implements BrandMerchantService {

  @Value("${finance.brand.merchant.channel}")
  private String channel;

  @Resource
  private StudioRpcService studioRpcService;

  @Resource
  private MerchantRpcService merchantRpcService;

  @Resource
  private BrandMerchantApplyRpService brandMerchantApplyRpService;

  @Override
  public void apply(ApplyBrandMerchantParams params) {

    StudioVO studio = studioRpcService.getStudio(params.getStudioId());
    BrandMerchantApply exist = brandMerchantApplyRpService.getLatestOneSuccessByBrandId(studio.getBrandId());
    BrandMerchantApply apply = MerchantConvert.convertApply(params, studio, exist, channel);

    try {
      brandMerchantApplyRpService.insert(apply);

      ApplyMerchantRequest request = MerchantConvert.convertRequest(channel, apply.getApplyNo(),
          studio.getBrandId(), params);
      merchantRpcService.apply(request);
    } catch (Exception e) {
      brandMerchantApplyRpService.updateById(
          BrandMerchantApply.builder().id(apply.getId()).openState(OpenStateEnums.FAIL)
              .openFailMessage(e.getMessage()).build());
    }

  }

}
