package com.jiejing.fitness.finance.api.cashier.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/4/7 18:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "场馆结算记录VO")
public class StudioSettleVO {

  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "商户ID")
  private Long merchantId;

  @ApiModelProperty(value = "商户号")
  private String merchantNo;

  @ApiModelProperty(value = "状态")
  private String transState;

  @ApiModelProperty(value = "结算金额（元）")
  private BigDecimal transAmount;

  @ApiModelProperty(value = "结算银行卡号")
  private String cardNo;

  @ApiModelProperty(value = "结算银行")
  private String bankName;

  @ApiModelProperty(value = "结算日期")
  private Date settleDate;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更新时间")
  private Date updateTime;

}
