package com.jiejing.fitness.finance.app.controller.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.merchant.BrandMerchantApi;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindBrandMerchantXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetBrandMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageBrandMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.fitness.finance.service.merchant.params.ApplyBrandMerchantParams;
import com.jiejing.fitness.finance.service.merchant.params.PageBrandMerchantApplyParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/22 11:53
 */
@RestController
public class BrandMerchantController implements BrandMerchantApi {

  @Resource
  private BrandMerchantService brandMerchantService;

  @ApiOperation(value = "品牌入驻商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/apply")
  @Override
  public JsonResult<Void> apply(@RequestBody @Valid ApplyBrandMerchantRequest request) {
    ApplyBrandMerchantParams params = BeanUtil.map(request, ApplyBrandMerchantParams.class);
    brandMerchantService.apply(params);
    return JsonResult.success();
  }

  @ApiOperation(value = "查询品牌当前绑定的商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/get")
  @Override
  public JsonResult<BrandMerchantVO> get(@RequestBody @Valid GetBrandMerchantRequest request) {
    return JsonResult.success(brandMerchantService.getMerchant(request.getBrandId()));
  }

  @ApiOperation(value = "查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/getApply")
  @Override
  public JsonResult<BrandMerchantApplyVO> getApply(@RequestBody @Valid GetBrandMerchantApplyRequest request) {
    return JsonResult.success(brandMerchantService.getApply(request.getId()));
  }

  @ApiOperation(value = "分页查询品牌进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/pageApply")
  @Override
  public JsonResult<PageVO<BrandMerchantApplyVO>> pageApply(
      @RequestBody @Valid PageBrandMerchantApplyRequest request) {
    PageBrandMerchantApplyParams params = BeanUtil.map(request, PageBrandMerchantApplyParams.class);
    return JsonResult.success(brandMerchantService.pageApply(params));
  }

  @ApiOperation(value = "绑定微信小程序appId", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/bindXcxAppId")
  @Override
  public JsonResult<BrandMerchantBindXcxAppIdVO> bindXcxAppId(
      @RequestBody @Valid BindBrandMerchantXcxAppIdRequest request) {
    return JsonResult.success(brandMerchantService.bindXcxAppId(request.getBrandId(), request.getAppId()));
  }

  @ApiOperation(value = "校验微信小程序appId绑定结果", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/checkBindXcxAppId")
  @Override
  public JsonResult<BrandMerchantBindXcxAppIdVO> checkBindXcxAppId(
      @RequestBody @Valid BindBrandMerchantXcxAppIdRequest request) {
    return JsonResult.success(
        brandMerchantService.checkBindXcxAppId(request.getBrandId(), request.getAppId()));
  }

}
