/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 品牌商户关联表（1:1）
 * </p>
 *
 * @author chengyubing, created on 2024-02-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class BrandToMerchant implements Serializable {

  private static final long serialVersionUID = -4973389381018495600L;

  /**
   * 备注: ID 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 品牌ID 是否允许为null: YES
   */
  private Long brandId;

  /**
   * 备注: paycenter的商户ID 是否允许为null: YES
   */
  private Long merchantId;

  /**
   * 备注: 创建时间 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String BRAND_ID = "brand_id";

  public static final String MERCHANT_ID = "merchant_id";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
