package com.jiejing.fitness.finance.service.merchant;

import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.BrandMerchantVO;
import com.jiejing.fitness.finance.service.merchant.params.ApplyBrandMerchantParams;
import com.jiejing.fitness.finance.service.merchant.params.PageBrandMerchantApplyParams;
import com.jiejing.paycenter.common.event.MerchantEvent;
import com.jiejing.paycenter.common.event.MerchantSubChannelConfigEvent;

/**
 * 品牌商户服务
 *
 * @author chengyubing
 * @since 2024/2/20 14:01
 */
public interface BrandMerchantService {

  /**
   * 进件申请
   *
   * @param params 请求参数
   */
  void apply(ApplyBrandMerchantParams params);

  /**
   * 进件申请回调
   *
   * @param event 事件
   */
  void callback(MerchantEvent event);

  /**
   * 获取品牌当前绑定的商户信息
   *
   * @param brandId 品牌ID
   * @return 商户
   */
  BrandMerchantVO getMerchant(Long brandId);

  /**
   * 获取申请记录详情
   *
   * @param id ID
   * @return 结果
   */
  BrandMerchantApplyVO getApply(Long id);

  /**
   * 分页查询品牌商户申请记录
   *
   * @param params 请求
   * @return 响应
   */
  PageVO<BrandMerchantApplyVO> pageApply(PageBrandMerchantApplyParams params);

  /**
   * 绑定小程序AppId
   *
   * @param brandId 品牌Id
   * @param appId   appId
   * @return 结果
   */
  BrandMerchantBindXcxAppIdVO bindXcxAppId(Long brandId, String appId);

  /**
   * 绑定小程序AppId结果
   *
   * @param brandId 品牌ID
   * @param appId   小程序appId
   * @return 结果
   */
  BrandMerchantBindXcxAppIdVO checkBindXcxAppId(Long brandId, String appId);

  /**
   * 绑定小程序AppId回调
   *
   * @param event 事件
   */
  void bindXcxAppIdCallback(MerchantSubChannelConfigEvent event);

}
