package com.jiejing.fitness.finance.api.axf;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.axf.request.CreateStudioAxfCommodityRequest;
import com.jiejing.fitness.finance.api.axf.request.GetStudioAxfCommodityRequest;
import com.jiejing.paycenter.common.model.vo.CommodityVO;
import com.jiejing.paycenter.common.model.vo.CreateCommodityVO;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 安心付商品API
 *
 * @author chengyubing
 * @since 2024/9/7 11:00
 */
@Component
public class StudioAxfCommodityApiFallback implements FallbackFactory<StudioAxfCommodityApi> {

  @Override
  public StudioAxfCommodityApi create(Throwable throwable) {
    return new StudioAxfCommodityApi() {
      @Override
      public JsonResult<CreateCommodityVO> create(CreateStudioAxfCommodityRequest request) {
        return JsonResult.rpcError();
      }

      @Override
      public JsonResult<CommodityVO> get(GetStudioAxfCommodityRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
