package com.jiejing.fitness.finance.api.axf.request;

import com.jiejing.paycenter.common.model.request.CycleCommodityAttr;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chengyubing
 * @since 2024/9/11 16:55
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "创建一课一价商品请求")
public class CreateStudioAxfCommodityRequest {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(value = "订单ID", required = true)
  @NotNull(message = "订单ID不能为空")
  private Long voucherId;

  @ApiModelProperty(value = "原价（元）", required = true)
  @NotNull(message = "原价不能为空")
  private BigDecimal originalPrice;

  @ApiModelProperty(value = "售价（元）", required = true)
  @NotNull(message = "售价不能为空")
  private BigDecimal salePrice;

  @ApiModelProperty(value = "周期类商品属性")
  private CycleCommodityAttr cycleCommodityAttr;

}
