package com.jiejing.fitness.finance.api.axf.vo;

import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.LicenseTypeEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;

/**
 * @author chengyubing
 * @since 2024/9/7 11:11
 */
@Data
@ApiModel(description = "先学后付申请记录VO")
public class StudioAxfApplyVO {

  @ApiModelProperty(value = "申请记录ID")
  private Long id;

  @ApiModelProperty(value = "渠道号")
  private String channelNo;

  @ApiModelProperty(value = "申请类型")
  private String applyType;

  @ApiModelProperty(value = "支付宝pid")
  private String merchantNo;

  @ApiModelProperty(value = "商户ID")
  private Long merchantId;

  @ApiModelProperty(value = "场馆ID")
  private Long studioId;

  @ApiModelProperty(value = "场馆名称")
  private String studioName;

  @ApiModelProperty(value = "商户简称")
  private String shortName;

  @ApiModelProperty(value = "企业类型")
  private String companyType;

  @ApiModelProperty(value = "开通状态：+ INIT: 初始+ AXF_PROCESS: 安心付开通中+ AXF_SUCCESS: 安心付开通成功+ STORE_PROCESS: 门店开通中+ STORE_SUCCESS: 门店开通成功")
  private String state;

  @ApiModelProperty(value = "结算账户号")
  private String cardNo;

  @ApiModelProperty(value = "营业执照编号")
  private String licenseCode;

  @ApiModelProperty(value = "营业执照名称")
  private String licenseName;

  @ApiModelProperty(value = "营业执照类型")
  private LicenseTypeEnums licenseType;

  @ApiModelProperty(value = "营业执照有效期类型")
  private ExpireTypeEnums licenseExpireType;

  @ApiModelProperty(value = "营业执照有效期开始时间")
  private Date licenseStartTime;

  @ApiModelProperty(value = "营业执照有效期结束时间")
  private Date licenseEndTime;

  @ApiModelProperty(value = "法人姓名")
  private String legalName;

  @ApiModelProperty(value = "法人证件号")
  private String legalCertNo;

  @ApiModelProperty(value = "联系人手机号")
  private String phone;

  @ApiModelProperty(value = "经营地址-省份code")
  private String businessProvinceCode;

  @ApiModelProperty(value = "经营地址-省份名称")
  private String businessProvinceName;

  @ApiModelProperty(value = "经营地址城市code")
  private String businessCityCode;

  @ApiModelProperty(value = "经营地址城市名称")
  private String businessCityName;

  @ApiModelProperty(value = "经营地址县区code")
  private String businessDistrictCode;

  @ApiModelProperty(value = "经营地址县区名称")
  private String businessDistrictName;

  @ApiModelProperty(value = "经营详细地址")
  private String businessAddress;

  @ApiModelProperty(value = "营业执照资源ID")
  private Long licenseResourceId;

  @ApiModelProperty(value = "门头照资源ID")
  private Long storeHeadResourceId;

  @ApiModelProperty(value = "营业执照资源Url")
  private String licenseResourceUrl;

  @ApiModelProperty(value = "门头照资源Url")
  private String storeHeadResourceUrl;

  @ApiModelProperty(value = "失败原因")
  private String failMessage;

  @ApiModelProperty(value = "操作人ID")
  private Long opId;

  @ApiModelProperty(value = "操作人姓名")
  private String opName;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "更细时间")
  private Date updateTime;

}
