package com.jiejing.fitness.finance.app.controller.axf;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.axf.StudioAxfCommodityApi;
import com.jiejing.fitness.finance.api.axf.request.CreateStudioAxfCommodityRequest;
import com.jiejing.fitness.finance.api.axf.request.GetStudioAxfCommodityRequest;
import com.jiejing.fitness.finance.service.axf.AxfService;
import com.jiejing.paycenter.common.model.vo.CommodityVO;
import com.jiejing.paycenter.common.model.vo.CreateCommodityVO;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/9/7 11:30
 */
@RestController
public class StudioAxfCommodityController implements StudioAxfCommodityApi {

  @Resource
  private AxfService axfService;

  @ApiOperation(value = "创建安心付一课一价商品")
  @PostMapping(value = "/private/axfCommodity/create")
  @Override
  public JsonResult<CreateCommodityVO> create(@RequestBody @Valid CreateStudioAxfCommodityRequest request) {
    return JsonResult.success(axfService.createCommodity(request));
  }

  @ApiOperation(value = "查询安心付一课一价商品")
  @PostMapping(value = "/private/axfCommodity/get")
  @Override
  public JsonResult<CommodityVO> get(@RequestBody @Valid GetStudioAxfCommodityRequest request) {
    return JsonResult.success(axfService.getCommodity(request.getThirdCommodityId()));
  }
}
