/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 场馆安心付授权申请记录
 * </p>
 *
 * @author chengyubing, created on 2024-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class StudioAxfAuthApply implements Serializable {

  private static final long serialVersionUID = -166947593419927514L;

  /**
   * 备注: 主键
   * 是否允许为null: NO
   */
  @TableId(value = "id", type = IdType.ID_WORKER)
  private Long id;

  /**
   * 备注: 场馆id
   * 是否允许为null: YES
   */
  private Long studioId;

  /**
   * 备注: 支付宝用户id
   * 是否允许为null: YES
   */
  private String userId;

  /**
   * 备注: token
   * 是否允许为null: YES
   */
  private String appAuthToken;

  /**
   * 备注: 刷新token
   * 是否允许为null: YES
   */
  private String appRefreshToken;

  /**
   * 备注: 授权appid
   * 是否允许为null: YES
   */
  private String authAppId;

  /**
   * 备注: expiresIn
   * 是否允许为null: YES
   */
  private Long expiresIn;

  /**
   * 备注: re_expires_in
   * 是否允许为null: YES
   */
  private Integer reExpiresIn;

  /**
   * 备注: 授权是否进件
   * 默认值: NO
   * 是否允许为null: YES
   */
  private String used;

  /**
   * 备注: 创建时间
   * 是否允许为null: YES
   */
  private Date createTime;

  /**
   * 备注: 更新时间
   * 是否允许为null: YES
   */
  private Date updateTime;


  public static final String ID = "id";

  public static final String STUDIO_ID = "studio_id";

  public static final String USER_ID = "user_id";

  public static final String APP_AUTH_TOKEN = "app_auth_token";

  public static final String APP_REFRESH_TOKEN = "app_refresh_token";

  public static final String AUTH_APP_ID = "auth_app_id";

  public static final String EXPIRES_IN = "expires_in";

  public static final String RE_EXPIRES_IN = "re_expires_in";

  public static final String USED = "used";

  public static final String CREATE_TIME = "create_time";

  public static final String UPDATE_TIME = "update_time";

}
