package com.jiejing.fitness.finance.service.axf;

import com.jiejing.common.enums.ConfirmEnum;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.axf.request.StudioAxfApplyRequest;
import com.jiejing.fitness.finance.api.axf.request.*;
import com.jiejing.fitness.finance.api.axf.vo.*;
import com.jiejing.paycenter.common.enums.merchant.GrantTypeEnums;
import com.jiejing.paycenter.common.event.CommodityOrderEvent;
import com.jiejing.paycenter.common.event.MerchantEvent;
import com.jiejing.paycenter.common.event.OrderDeductionEvent;
import com.jiejing.paycenter.common.event.StoreEvent;
import com.jiejing.paycenter.common.model.vo.BindCardVO;
import com.jiejing.paycenter.common.model.vo.CancelCommodityOrderVO;
import com.jiejing.paycenter.common.model.vo.CommodityVO;
import com.jiejing.paycenter.common.model.vo.CreateCommodityVO;
import java.util.Date;
import java.util.List;

/**
 * @author chengyubing
 * @since 2024/9/7 11:35
 */
public interface AxfService {

  /**
   * 获取当前绑定的商户信息（开通中、开通失败、未开通都返回null）
   */
  StudioAxfApplyVO getMerchant(Long instId);

  /**
   * 授权
   */
  StudioAuthTokenVO authToken(Long instId, GrantTypeEnums grantType, String code, String refreshToken);

  /**
   * 获取授权信息
   */
  StudioAuthTokenVO getAuthToken(Long instId);

  /**
   * 获取可配置的结算账号
   */
  List<String> listSettleAccount(Long instId);

  /**
   * 进件
   */
  Long apply(StudioAxfApplyRequest params);

  /**
   * 绑定结算账户
   */
  BindCardVO bindCard(Long id, String cardNo);

  /**
   * 解约订购单
   */
  CancelCommodityOrderVO cancelOrder(Long id, Long opId);

  /**
   * 商户回调
   */
  void callback(MerchantEvent event);

  /**
   * 门店回调
   */
  void storeCallback(StoreEvent event);

  /**
   * 订购单回调
   */
  void orderCallback(CommodityOrderEvent event);

  /**
   * 订购单扣款回调
   */
  void orderDeductionCallback(OrderDeductionEvent event);

  /**
   * 查询申请记录
   */
  StudioAxfApplyVO getById(Long id);

  /**
   * 查询最近的申请记录
   */
  StudioAxfApplyVO getLatestApply(Long instId, String merchantNo);

  /**
   * 分页查询申请记录
   */
  PageVO<StudioAxfApplyVO> page(PageStudioAxfApplyRequest request);

  /**
   * 统计申请记录
   */
  AggStudioAxfApplyVO agg();

  /**
   * 分页查询订购单
   */
  PageVO<StudioAxfOrderVO> pageOrder(PageStudioAxfOrderRequest request);

  /**
   * 统计订购单
   */
  AggStudioAxfOrderVO aggOrder(PageStudioAxfOrderRequest request);

  /**
   * 查询订购单详情
   */
  StudioAxfOrderVO getOrder(Long id);

  /**
   * 创建商品
   */
  CreateCommodityVO createCommodity(CreateStudioAxfCommodityRequest request);

  /**
   * 查询安心付一课一价商品
   */
  CommodityVO getCommodity(String thirdCommodityId);

  /**
   * 查询订购单扣款明细
   */
  List<StudioAxfOrderDeductionVO> listDeduction(Long orderId);

  /**
   * 校验是否存在失败的扣款
   */
  ConfirmEnum existFailDeduction(Long orderId);

  /**
   * 查询订购单追缴明细
   */
  List<StudioAxfOrderRecoveryVO> listRecovery(Long deductionId);

  /**
   * 解约失败
   */
  void cancelFail(Long id, Long opId, Date date);

  /**
   * 根据订单查询订购单
   */
  StudioAxfOrderVO getByVoucherId(Long voucherId);

}
