package com.jiejing.fitness.finance.service.cashier;

import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.cashier.vo.BrandCashierRecordVO;
import com.jiejing.fitness.finance.service.cashier.params.PageBrandCashierParams;
import java.util.List;

/**
 * @author chengyubing
 * @since 2024/2/29 11:05
 */
public interface BrandCashierService {

  /**
   * 查询详情
   *
   * @param id ID
   * @return 结果
   */
  BrandCashierRecordVO getById(Long id);

  /**
   * 根据订单号查询列表
   *
   * @param orderNo 订单号
   * @return 结果
   */
  List<BrandCashierRecordVO> listByOrderNo(String orderNo);

  /**
   * 分页
   *
   * @param params 参数
   * @return 结果
   */
  PageVO<BrandCashierRecordVO> page(PageBrandCashierParams params);

}
