package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import feign.hystrix.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * @author chengyubing
 * @since 2024/2/22 11:49
 */
@Component
public class BrandMerchantApiFallback implements FallbackFactory<BrandMerchantApi> {

  @Override
  public BrandMerchantApi create(Throwable throwable) {
    return new BrandMerchantApi() {
      @Override
      public JsonResult<Void> apply(ApplyBrandMerchantRequest request) {
        return JsonResult.rpcError();
      }
    };
  }
}
