package com.jiejing.fitness.finance.api.merchant.request;

import com.jiejing.paycenter.common.enums.merchant.CardTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CertTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.CompanyTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ExpireTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.ResourceTypeEnums;
import com.jiejing.paycenter.common.model.ResourceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 品牌申请商户请求
 *
 * @author chengyubing
 * @since 2024/2/20 14:03
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "申请品牌商户请求信息")
public class ApplyBrandMerchantRequest {

  @ApiModelProperty(value = "场馆ID", required = true)
  @NotNull(message = "场馆ID不能为空")
  private Long studioId;

  @ApiModelProperty(value = "商户名称", required = true)
  @NotBlank(message = "商户名称不能为空")
  private String merchantName;

  @ApiModelProperty(value = "商户简称", required = true)
  @NotBlank(message = "商户简称不能为空")
  private String shortName;

  @ApiModelProperty(value = "企业类型", required = true)
  @NotNull(message = "企业类型不能为空")
  private CompanyTypeEnums companyType;

  @ApiModelProperty(value = "经营地址：省", required = true)
  @NotBlank(message = "经营地址不能为空")
  private String businessProvince;

  @ApiModelProperty(value = "经营地址：市", required = true)
  @NotBlank(message = "经营地址不能为空")
  private String businessCity;

  @ApiModelProperty(value = "经营地址：区", required = true)
  @NotBlank(message = "经营地址不能为空")
  private String businessDistrict;

  @ApiModelProperty(value = "经营详细地址", required = true)
  @NotBlank(message = "经营地址不能为空")
  private String businessAddress;

  @ApiModelProperty(value = "营业执照编号", required = true)
  @NotBlank(message = "营业执照编号不能为空")
  private String licenseCode;

  @ApiModelProperty(value = "营业执照有效期类型", required = true)
  @NotNull(message = "营业执照有效期类型不能为空")
  private ExpireTypeEnums licenseExpireType;

  @ApiModelProperty(value = "营业执照有效期开始日期", required = true)
  @NotNull(message = "营业执照有效期开始日期不能为空")
  private Date licenseStartDate;

  @ApiModelProperty(value = "营业执照有效期截止日期")
  private Date licenseEndDate;

  @ApiModelProperty(value = "营业护照规定的经营范围", required = true)
  @NotBlank(message = "经营范围不能为空")
  private String licenseBusinessScope;

  @ApiModelProperty(value = "营业执照成立时间", required = true)
  @NotNull(message = "成立时间不能为空")
  private Date licenseFoundDate;

  @ApiModelProperty(value = "商户注册地址：省", required = true)
  @NotBlank(message = "注册省不能为空")
  private String licenseProvince;

  @ApiModelProperty(value = "商户注册地址：市", required = true)
  @NotBlank(message = "注册市不能为空")
  private String licenseCity;

  @ApiModelProperty(value = "商户注册地址：区", required = true)
  @NotBlank(message = "注册区不能为空")
  private String licenseDistrict;

  @ApiModelProperty(value = "营业执照注册详细地址", required = true)
  @NotBlank(message = "注册地址不能为空")
  private String licenseAddress;

  @ApiModelProperty(value = "法人姓名", required = true)
  @NotBlank(message = "法人姓名不能为空")
  private String legalName;

  @ApiModelProperty(value = "法人证件号码", required = true)
  @NotBlank(message = "法人证件号码不能为空")
  private String legalCertNo;

  @ApiModelProperty(value = "法人证件类型", required = true)
  @NotNull(message = "法人证件类型不能为空")
  private CertTypeEnums legalCertType;

  @ApiModelProperty(value = "法人证件有效期类型", required = true)
  @NotNull(message = "法人证件有效期类型不能为空")
  private ExpireTypeEnums legalCertExpireType;

  @ApiModelProperty(value = "法人证件有效期开始日期", required = true)
  @NotNull(message = "法人证件有效期开始日期不能为空")
  private Date legalCertStartDate;

  @ApiModelProperty(value = "法人证件有效期截止日期")
  private Date legalCertEndDate;

  @ApiModelProperty(value = "法人手机号")
  private String legalPhone;

  @ApiModelProperty(value = "法人证件地址：省")
  private String legalProvince;

  @ApiModelProperty(value = "法人证件地址：市")
  private String legalCity;

  @ApiModelProperty(value = "法人证件地址：区")
  private String legalDistrict;

  @ApiModelProperty(value = "法人证件详细地址")
  private String legalAddress;

  @ApiModelProperty(value = "联系人邮箱", required = true)
  @NotBlank(message = "联系人邮箱不能为空")
  private String contactEmail;

  @ApiModelProperty(value = "结算卡类型", required = true)
  @NotNull(message = "结算卡类型不能为空")
  private CardTypeEnums bankCardType;

  @ApiModelProperty(value = "结算卡卡号", required = true)
  @NotBlank(message = "结算卡卡号不能为空")
  private String bankCardNo;

  @ApiModelProperty(value = "银行卡账户名（对私卡：持卡人姓名；对公卡：营业执照名称）", required = true)
  @NotBlank(message = "结算卡账户名不能为空")
  private String bankCardName;

  @ApiModelProperty(value = "持卡人手机号", notes = "对私卡必填")
  private String bankPhone;

  @ApiModelProperty(value = "结算卡证件号码（对私卡：持卡人身份证；对公卡：营业执照号）", required = true)
  @NotBlank(message = "结算卡证件号码不能为空")
  private String bankCertNo;

  @ApiModelProperty(value = "结算卡持卡人证件类型", required = true)
  @NotNull(message = "证件类型不能为空")
  private CertTypeEnums bankCertType;

  @ApiModelProperty(value = "结算卡证件有效期类型", notes = "对私卡必填")
  private ExpireTypeEnums bankCertExpireType;

  @ApiModelProperty(value = "持卡人证件有效期开始日期", notes = "对私卡必填")
  private Date bankCertStartDate;

  @ApiModelProperty(value = "持卡人证件有效期截止日期")
  private Date bankCertEndDate;

  @ApiModelProperty(value = "基本存款账户编号|开户许可证核准号", notes = "对公卡必填")
  private String bankBaseDepositNo;

  @ApiModelProperty(value = "银行编码", notes = "对公卡必填")
  private String bankCode;

  @ApiModelProperty(value = "bankName", notes = "对公卡必填")
  private String bankName;

  @ApiModelProperty(value = "支行名称", notes = "对公卡必填")
  private String bankBranchName;

  @ApiModelProperty(value = "支行号", notes = "对公卡必填")
  private String bankBranchCode;

  @ApiModelProperty(value = "结算卡开卡地址：省")
  private String bankCardProvince;

  @ApiModelProperty(value = "结算卡开卡地址：市")
  private String bankCardCity;

  @ApiModelProperty(value = "结算卡开卡地址：区")
  private String bankCardDistrict;

  @ApiModelProperty(value = "结算卡开卡详细地址")
  private String bankCardAddress;

  @ApiModelProperty(value = "资源信息", required = true)
  @NotEmpty(message = "资源信息不能为空")
  @Valid
  private Map<ResourceTypeEnums, ResourceInfo> resourceInfo;

}
