package com.jiejing.fitness.finance.app.controller.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.merchant.BrandMerchantApi;
import com.jiejing.fitness.finance.api.merchant.request.ApplyBrandMerchantRequest;
import com.jiejing.fitness.finance.service.merchant.BrandMerchantService;
import com.jiejing.fitness.finance.service.merchant.params.ApplyBrandMerchantParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/22 11:53
 */
@RestController
public class BrandMerchantController implements BrandMerchantApi {

  @Resource
  private BrandMerchantService brandMerchantService;

  @ApiOperation(value = "品牌入驻商户", tags = {TAG})
  @PostMapping(value = "/private/brandMerchant/apply")
  @Override
  public JsonResult<Void> apply(@RequestBody @Valid ApplyBrandMerchantRequest request) {
    ApplyBrandMerchantParams params = BeanUtil.map(request, ApplyBrandMerchantParams.class);
    brandMerchantService.apply(params);
    return JsonResult.success();
  }
}
