package com.jiejing.fitness.finance.api.config;

import com.alibaba.fastjson.JSONObject;
import com.jiejing.common.model.JsonResult;
import com.jiejing.fitness.finance.api.config.request.GetConfigRequest;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/6/4 11:22
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = FinanceConfigApiFallback.class)
public interface FinanceConfigApi {

  String TAG = "金融相关配置";

  @ApiOperation(value = "获取finance的配置信息", tags = {TAG})
  @PostMapping(value = "/private/financeConfig/get")
  JsonResult<JSONObject> get(GetConfigRequest request);

}
