/*
 * Copyright © 2024 Hangzhou Jiejing Technology Co., Ltd. All rights reserved.
 *
 * The copyright of the company's program code belongs to Hangzhou Jiejing Technology Co., Ltd. No one can illegally copy it without the explicit permission of this website.
 * Official website: www.xiaomai5.com
 *
 *
 *
 * Copyright © 2024 杭州杰竞科技有限公司 版权所有.
 *
 * 本公司程序代码的版权归杭州杰竞科技有限公司所有，未经本网站的明确许可，任何人不得非法复制。
 * 官网: www.xiaomai5.com
 */

package com.jiejing.fitness.finance.repository.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jiejing.fitness.finance.repository.entity.StudioEmbeddedXcxApply;
import com.jiejing.fitness.finance.repository.mapper.StudioEmbeddedXcxApplyMapper;
import com.jiejing.mbp.MapperRepoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 场馆半屏小程序申请记录 服务实现类
 * </p>
 *
 * @author chengyubing, created on 2024-08-13
 */
@Service
public class StudioEmbeddedXcxApplyRpService extends
    MapperRepoService<Long, StudioEmbeddedXcxApply, StudioEmbeddedXcxApplyMapper> {

  public Map<String, StudioEmbeddedXcxApply> mapByStudioIdAndAppId(Long studioId,
      String componentAppId, String systemXcxAppId, List<String> appIds) {
    return this.listByStudioIdAndAppId(studioId, componentAppId, systemXcxAppId, appIds)
        .stream().collect(Collectors.toMap(StudioEmbeddedXcxApply::getAppId, e -> e));
  }

  public List<StudioEmbeddedXcxApply> listByStudioIdAndAppId(Long studioId, String componentAppId,
      String systemXcxAppId, List<String> appIds) {
    QueryWrapper<StudioEmbeddedXcxApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioEmbeddedXcxApply.STUDIO_ID, studioId);
    wrapper.eq(StudioEmbeddedXcxApply.COMPONENT_APP_ID, componentAppId);
    wrapper.eq(StudioEmbeddedXcxApply.AUTHORIZER_APP_ID, systemXcxAppId);
    wrapper.in(StudioEmbeddedXcxApply.APP_ID, appIds);
    return Optional.ofNullable(this.baseMapper.selectList(wrapper)).orElse(new ArrayList<>(1));
  }

  public StudioEmbeddedXcxApply getByStudioIdAndAppId(Long studioId, String componentAppId,
      String systemXcxAppId, String appId) {
    QueryWrapper<StudioEmbeddedXcxApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioEmbeddedXcxApply.STUDIO_ID, studioId);
    wrapper.eq(StudioEmbeddedXcxApply.COMPONENT_APP_ID, componentAppId);
    wrapper.eq(StudioEmbeddedXcxApply.APP_ID, appId);
    wrapper.eq(StudioEmbeddedXcxApply.AUTHORIZER_APP_ID, systemXcxAppId);
    return Optional.ofNullable(this.baseMapper.selectList(wrapper))
        .orElse(new ArrayList<>(1))
        .stream().findFirst().orElse(null);
  }

  public List<StudioEmbeddedXcxApply> listByAppIds(String componentAppId, String systemXcxAppId,
      List<String> appIds) {
    QueryWrapper<StudioEmbeddedXcxApply> wrapper = new QueryWrapper<>();
    wrapper.eq(StudioEmbeddedXcxApply.COMPONENT_APP_ID, componentAppId);
    wrapper.eq(StudioEmbeddedXcxApply.AUTHORIZER_APP_ID, systemXcxAppId);
    wrapper.in(StudioEmbeddedXcxApply.APP_ID, appIds);
    return Optional.ofNullable(this.baseMapper.selectList(wrapper)).orElse(new ArrayList<>(1));
  }
}
