package com.jiejing.fitness.finance.api.axf;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.request.IdRequest;
import com.jiejing.fitness.finance.api.axf.request.*;
import com.jiejing.fitness.finance.api.axf.vo.*;
import com.jiejing.fitness.request.StudioIdRequest;
import com.jiejing.paycenter.common.model.vo.BindCardVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 安心付
 *
 * @author chengyubing
 * @since 2024/9/7 11:00
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = StudioAxfApiFallback.class)
public interface StudioAxfApi {

  @ApiOperation(value = "authToken")
  @PostMapping(value = "/private/axf/authToken")
  JsonResult<StudioAuthTokenVO> authToken(AxfAuthTokenRequest request);

  @ApiOperation(value = "getAuthToken")
  @PostMapping(value = "/private/axf/getAuthToken")
  JsonResult<StudioAuthTokenVO> getAuthToken(GetAxfAuthTokenRequest request);

  @ApiOperation(value = "申请开通安心付")
  @PostMapping(value = "/private/axf/apply")
  JsonResult<Long> apply(StudioAxfApplyRequest request);

  @ApiOperation(value = "查询可绑定的安心付结算账户")
  @PostMapping(value = "/private/axf/listSettleAccount")
  JsonResult<List<String>> listSettleAccount(ListAxfSettleAccountRequest request);

  @ApiOperation(value = "绑定结算账户")
  @PostMapping(value = "/private/axf/bindCard")
  JsonResult<BindCardVO> bindCard(BindAxfSettleAccountRequest request);

  @ApiOperation(value = "获取最新一条安心付申请记录")
  @PostMapping(value = "/private/axf/getLatestApply")
  JsonResult<StudioAxfApplyVO> getLatestApply(GetLatestAxfApplyRequest request);

  @ApiOperation(value = "查询开通安心付申请结果")
  @PostMapping(value = "/private/axf/getById")
  JsonResult<StudioAxfApplyVO> getById(IdRequest request);

  @ApiOperation(value = "获取当前绑定的商户信息（开通中、开通失败、未开通都返回null）")
  @PostMapping(value = "/private/axf/getMerchant")
  JsonResult<StudioAxfApplyVO> getMerchant(StudioIdRequest request);

  @ApiOperation(value = "分页查询开通安心付申请记录")
  @PostMapping(value = "/private/axf/page")
  JsonResult<PageVO<StudioAxfApplyVO>> page(PageStudioAxfApplyRequest request);

  @ApiOperation(value = "统计")
  @PostMapping(value = "/private/axf/agg")
  JsonResult<AggStudioAxfApplyVO> agg();

}
