package com.jiejing.fitness.finance.service.rpc;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jiejing.common.model.JsonResult;
import com.jiejing.paycenter.api.merchant.MerchantApi;
import com.jiejing.paycenter.api.merchant.MerchantQueryApi;
import com.jiejing.paycenter.api.merchant.request.ApplyMerchantRequest;
import com.jiejing.paycenter.api.merchant.request.AuthSubChannelRequest;
import com.jiejing.paycenter.api.merchant.request.ConfigSubChannelRequest;
import com.jiejing.paycenter.api.merchant.request.GetMerchantByIdRequest;
import com.jiejing.paycenter.api.merchant.request.UploadRequest;
import com.jiejing.paycenter.api.merchant.vo.ApplyMerchantResultVO;
import com.jiejing.paycenter.api.merchant.vo.AuthSubChannelVO;
import com.jiejing.paycenter.api.merchant.vo.ConfigSubChannelVO;
import com.jiejing.paycenter.api.merchant.vo.MerchantVO;
import com.jiejing.paycenter.api.merchant.vo.UploadVO;
import com.jiejing.paycenter.common.enums.common.OpenStateEnums;
import com.jiejing.paycenter.common.enums.merchant.AuthPhaseEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelAuthTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelConfigTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/20 16:39
 */
@Slf4j
@Service
public class MerchantRpcService {

  @Resource
  private MerchantApi merchantApi;

  @Resource
  private MerchantQueryApi merchantQueryApi;

  public String upload(UploadRequest request) {
    JsonResult<UploadVO> result = merchantApi.upload(request);
    result.assertSuccess();
    return result.getResult().getThirdId();
  }

  public ApplyMerchantResultVO apply(ApplyMerchantRequest request) {
    JsonResult<ApplyMerchantResultVO> result = merchantApi.apply(request);
    result.assertSuccess();
    return result.getResult();
  }

  public MerchantVO getByMerchantId(Long merchantId) {
    GetMerchantByIdRequest request = GetMerchantByIdRequest.builder().merchantId(merchantId).build();
    JsonResult<MerchantVO> result = merchantQueryApi.getById(request);
    result.assertSuccess();
    return result.getResult();
  }

  public ConfigSubChannelVO bindAppIdWxXcxOffline(String channelNo, Long merchantId, String appId) {
    JsonResult<ConfigSubChannelVO> result = merchantApi.configSubChannel(ConfigSubChannelRequest.builder()
        .applyNo(IdWorker.getIdStr())
        .appId(appId)
        .merchantId(merchantId)
        .channelNo(channelNo)
        .subChannel(SubChannelEnums.WX)
        .configType(SubChannelConfigTypeEnums.WX_XCX_OFFLINE)
        .build());
    if (!result.getSuccess()) {
      return ConfigSubChannelVO.builder().state(OpenStateEnums.FAIL.name()).failMessage(result.getMessage())
          .build();
    }
    return result.getResult();
  }

  public AuthSubChannelVO authSubChannel(String channel, Long merchantId, SubChannelEnums subChannel,
      SubChannelAuthTypeEnums authType) {
    JsonResult<AuthSubChannelVO> result = merchantApi.authSubChannel(AuthSubChannelRequest.builder()
        .channelNo(channel)
        .merchantId(merchantId)
        .subChannel(subChannel)
        .authType(authType)
        .build());
    if (!result.getSuccess()) {
      return AuthSubChannelVO.builder()
          .state(OpenStateEnums.FAIL.name())
          .phase(AuthPhaseEnums.APPLY_COMMIT_FAIL.name())
          .failMessage(result.getMessage()).build();
    }
    return result.getResult();
  }
}
