package com.jiejing.fitness.finance.api.bank;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.bank.request.PageBankRequest;
import com.jiejing.fitness.finance.api.bank.request.PageBranchBankRequest;
import com.jiejing.fitness.finance.api.bank.vo.BankVO;
import com.jiejing.fitness.finance.api.bank.vo.BranchBankVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/4/1 14:39
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = BankApiFallback.class)
public interface BankApi {

  String TAG = "【银行】银行管理";

  @ApiOperation(value = "分页查询银行列表", tags = TAG)
  @PostMapping(value = "/private/bank/pageBank")
  JsonResult<PageVO<BankVO>> pageBank(PageBankRequest request);

  @ApiOperation(value = "分页查询支行列表", tags = TAG)
  @PostMapping(value = "/private/bank/pageBranchBank")
  JsonResult<PageVO<BranchBankVO>> pageBranchBank(PageBranchBankRequest request);

}
