package com.jiejing.fitness.finance.service.merchant;

import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioEmbeddedXcxVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import com.jiejing.fitness.finance.repository.entity.PartyToMerchant;
import com.jiejing.fitness.finance.service.merchant.params.ApplyStudioMerchantParams;
import com.jiejing.fitness.finance.service.merchant.params.PageStudioMerchantApplyParams;
import com.jiejing.paycenter.common.enums.merchant.SubChannelAuthTypeEnums;
import com.jiejing.paycenter.common.enums.merchant.SubChannelEnums;
import com.jiejing.paycenter.common.event.MerchantEvent;
import java.util.List;
import java.util.Set;

/**
 * @author chengyubing
 * @since 2024/3/5 09:58
 */
public interface StudioMerchantService {

  /**
   * 进件申请
   *
   * @param params 请求参数
   */
  Long apply(ApplyStudioMerchantParams params);

  /**
   * 绑定
   *
   * @param studioId   场馆ID
   * @param merchantId 商户ID
   * @param flag       是否添加绑定记录
   */
  void bind(Long studioId, Long merchantId, Boolean flag);

  /**
   * 解绑
   *
   * @param studioId   场馆ID
   * @param merchantId 商户ID
   */
  void unbind(Long studioId, Long merchantId);

  /**
   * 解绑绑定了指定商户的所有场馆
   *
   * @param merchantId 商户ID
   */
  void unbindAll(Long merchantId);

  /**
   * 解绑绑定了指定商户的所有场馆
   *
   * @param merchantIds 商户ID
   */
  void unbindAll(Set<Long> merchantIds);

  /**
   * 进件申请回调
   *
   * @param event 事件
   */
  void callback(MerchantEvent event);

  /**
   * 获取场馆当前绑定的商户信息
   *
   * @param studioId 场馆ID
   * @return 商户
   */
  StudioMerchantVO getMerchant(Long studioId);

  /**
   * 获取申请记录详情
   *
   * @param id ID
   * @return 结果
   */
  StudioMerchantApplyVO getApply(Long id);

  /**
   * 分页查询场馆商户申请记录
   *
   * @param params 请求
   * @return 响应
   */
  PageVO<StudioMerchantApplyVO> pageApply(PageStudioMerchantApplyParams params);

  /**
   * 获取最后一条申请记录
   *
   * @param studioId 场馆ID
   * @return 申请记录
   */
  StudioMerchantApplyVO getLatestApply(Long studioId);

  /**
   * 绑定小程序AppId
   *
   * @param studioId 场馆ID
   * @param appId    appId
   * @return 结果
   */
  StudioMerchantBindXcxAppIdVO bindXcxAppId(Long studioId, String appId);

  /**
   * 获取关联关系
   *
   * @param studioId 场馆ID
   * @return 关联关系
   */
  PartyToMerchant getRelation(Long studioId);

  /**
   * 授权子渠道
   *
   * @param studioId   场馆ID
   * @param subChannel 子渠道
   * @param authType   授权类型
   * @return 结果
   */
  StudioMerchantAuthSubChannelVO authSubChannel(Long studioId, SubChannelEnums subChannel,
      SubChannelAuthTypeEnums authType);

  /**
   * 同步认证状态
   *
   * @param studioId   场馆ID
   * @param subChannel 子渠道
   * @param authType   授权类型
   * @return 认证状态
   */
  StudioMerchantAuthSubChannelVO syncAuthSubChannel(Long studioId, SubChannelEnums subChannel,
      SubChannelAuthTypeEnums authType);

  /**
   * 查询授权子渠道结果
   *
   * @param studioId 场馆ID
   * @return 结果
   */
  List<StudioMerchantAuthSubChannelVO> listAuthSubChannel(Long studioId);

  /**
   * 解绑前置校验
   *
   * @param studioId 场馆ID
   * @return true：绑定过其他场馆；false-没有绑定过
   */
  List<String> checkUnbind(Long studioId);

  /**
   * 获取最后一条成功的申请记录
   *
   * @param studioId 场馆ID
   * @return 申请记录
   */
  StudioMerchantApplyVO getLatestSuccessApply(Long studioId);

  /**
   * 获取半屏小程序绑定信息
   *
   * @param studioId 场馆ID
   * @param appId    小程序appId
   * @return 结果
   */
  StudioEmbeddedXcxVO getEmbeddedXcx(Long studioId, String appId);

  /**
   * 绑定半屏小程序
   *
   * @param studioId 场馆ID
   * @param appIds   小程序appId
   */
  void bindEmbeddedXcx(Long studioId, List<String> appIds);

  /**
   * 同步半屏小程序状态
   */
  void syncEmbeddedXcx();

}
