package com.jiejing.fitness.finance.api.merchant;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.fitness.finance.api.merchant.request.ApplyStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.AuthStudioSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.BindStudioMerchantXcxAppIdRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetAuthStudioSubChannelRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioLatestMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.GetStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.request.PageStudioMerchantApplyRequest;
import com.jiejing.fitness.finance.api.merchant.request.StudioMerchantPayRequest;
import com.jiejing.fitness.finance.api.merchant.request.UnbindStudioMerchantRequest;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantApplyVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantAuthSubChannelVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantBindXcxAppIdVO;
import com.jiejing.fitness.finance.api.merchant.vo.StudioMerchantVO;
import com.jiejing.paycenter.common.model.vo.PayVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author chengyubing
 * @since 2024/3/5 09:41
 */
@FeignClient(name = "FINANCE", url = "${rpc.url.fit-finance:http://app-fit-finance:7008}", fallbackFactory = StudioMerchantApiFallback.class)
public interface StudioMerchantApi {

  String TAG = "【场馆】商户管理";

  @ApiOperation(value = "场馆入驻商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/getMerchant")
  JsonResult<StudioMerchantVO> getMerchant(GetStudioMerchantRequest request);

  @ApiOperation(value = "场馆入驻商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/apply")
  JsonResult<Long> apply(ApplyStudioMerchantRequest request);

  @ApiOperation(value = "场馆绑定商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/bind")
  JsonResult<Void> bind(BindStudioMerchantRequest request);

  @ApiOperation(value = "场馆解绑商户", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/unbind")
  JsonResult<Void> unbind(UnbindStudioMerchantRequest request);

  @ApiOperation(value = "查询场馆进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/getApply")
  JsonResult<StudioMerchantApplyVO> getApply(GetStudioMerchantApplyRequest request);

  @ApiOperation(value = "查询最近一条申请记录", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/getLatestApply")
  JsonResult<StudioMerchantApplyVO> getLatestApply(GetStudioLatestMerchantApplyRequest request);

  @ApiOperation(value = "分页查询场馆进件申请记录", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/pageApply")
  JsonResult<PageVO<StudioMerchantApplyVO>> pageApply(PageStudioMerchantApplyRequest request);

  @ApiOperation(value = "绑定微信小程序appId", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/bindXcxAppId")
  JsonResult<StudioMerchantBindXcxAppIdVO> bindXcxAppId(BindStudioMerchantXcxAppIdRequest request);

  @ApiOperation(value = "授权子渠道", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/authSubChannel")
  JsonResult<StudioMerchantAuthSubChannelVO> authSubChannel(AuthStudioSubChannelRequest request);

  @ApiOperation(value = "查询授权子渠道结果", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/listAuthSubChannel")
  JsonResult<List<StudioMerchantAuthSubChannelVO>> listAuthSubChannel(GetAuthStudioSubChannelRequest request);

  @ApiOperation(value = "支付", tags = {TAG})
  @PostMapping(value = "/private/studioMerchant/pay")
  JsonResult<PayVO> pay(StudioMerchantPayRequest request);

}